/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.InterceptorEnvironment;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;

public final class EEModuleDescription
implements ResourceInjectionTarget {
    private final String applicationName;
    private volatile String moduleName;
    private final String earApplicationName;
    private volatile String distinctName = "";
    private final Map<String, ComponentDescription> componentsByName = new HashMap<String, ComponentDescription>();
    private final Map<String, List<ComponentDescription>> componentsByClassName = new HashMap<String, List<ComponentDescription>>();
    private final Map<String, EEModuleClassDescription> classDescriptions = new HashMap<String, EEModuleClassDescription>();
    private final Map<String, InterceptorClassDescription> interceptorClassOverrides = new HashMap<String, InterceptorClassDescription>();
    private final Map<String, InterceptorEnvironment> interceptorEnvironment = new HashMap<String, InterceptorEnvironment>();
    private final Map<String, String> messageDestinations = new HashMap<String, String>();
    private InjectedEENamespaceContextSelector namespaceContextSelector;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Map<String, Map<InjectionTarget, ResourceInjectionConfiguration>> resourceInjections = new HashMap<String, Map<InjectionTarget, ResourceInjectionConfiguration>>();
    private EEClassIntrospector classIntrospector;
    private final boolean appClient;

    public EEModuleDescription(String applicationName, String moduleName, String earApplicationName, boolean appClient) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.earApplicationName = earApplicationName;
        this.appClient = appClient;
    }

    public EEModuleClassDescription addOrGetLocalClassDescription(String className) {
        if (className == null) {
            throw EeMessages.MESSAGES.nullVar("name");
        }
        EEModuleClassDescription ret = this.classDescriptions.get(className);
        if (ret == null) {
            ret = new EEModuleClassDescription(className);
            this.classDescriptions.put(className, ret);
        }
        return ret;
    }

    EEModuleClassDescription getClassDescription(String className) {
        return this.classDescriptions.get(className);
    }

    public Collection<EEModuleClassDescription> getClassDescriptions() {
        return this.classDescriptions.values();
    }

    public void addComponent(ComponentDescription description) {
        String componentName = description.getComponentName();
        String componentClassName = description.getComponentClassName();
        if (componentName == null) {
            throw EeMessages.MESSAGES.nullVar("componentName");
        }
        if (componentClassName == null) {
            throw EeMessages.MESSAGES.nullVar("componentClassName");
        }
        if (this.componentsByName.containsKey(componentName)) {
            throw EeMessages.MESSAGES.componentAlreadyDefined(componentName);
        }
        this.componentsByName.put(componentName, description);
        List<ComponentDescription> list = this.componentsByClassName.get(componentClassName);
        if (list == null) {
            list = new ArrayList<ComponentDescription>(1);
            this.componentsByClassName.put(componentClassName, list);
        }
        list.add(description);
    }

    public void removeComponent(String componentName, String componentClassName) {
        this.componentsByName.remove(componentName);
        this.componentsByClassName.remove(componentClassName);
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            return this.moduleName;
        }
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean hasComponent(String name) {
        return this.componentsByName.containsKey(name);
    }

    public boolean isAppClient() {
        return this.appClient;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ComponentDescription getComponentByName(String name) {
        return this.componentsByName.get(name);
    }

    public List<ComponentDescription> getComponentsByClassName(String className) {
        List<ComponentDescription> ret = this.componentsByClassName.get(className);
        return ret == null ? Collections.emptyList() : ret;
    }

    public Collection<ComponentDescription> getComponentDescriptions() {
        return this.componentsByName.values();
    }

    public InjectedEENamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public void setNamespaceContextSelector(InjectedEENamespaceContextSelector namespaceContextSelector) {
        this.namespaceContextSelector = namespaceContextSelector;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public void setDistinctName(String distinctName) {
        if (distinctName == null) {
            throw EeMessages.MESSAGES.nullVar("distinctName");
        }
        this.distinctName = distinctName;
    }

    public String getEarApplicationName() {
        return this.earApplicationName;
    }

    public InterceptorClassDescription getInterceptorClassOverride(String className) {
        return this.interceptorClassOverrides.get(className);
    }

    public void addInterceptorMethodOverride(String className, InterceptorClassDescription override) {
        this.interceptorClassOverrides.put(className, InterceptorClassDescription.merge(this.interceptorClassOverrides.get(className), override));
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    @Override
    public void addResourceInjection(ResourceInjectionConfiguration injection) {
        String className = injection.getTarget().getClassName();
        Map<InjectionTarget, ResourceInjectionConfiguration> map = this.resourceInjections.get(className);
        if (map == null) {
            map = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();
            this.resourceInjections.put(className, map);
        }
        map.put(injection.getTarget(), injection);
    }

    public Map<InjectionTarget, ResourceInjectionConfiguration> getResourceInjections(String className) {
        Map<InjectionTarget, ResourceInjectionConfiguration> injections = this.resourceInjections.get(className);
        if (injections == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(injections);
    }

    public void addMessageDestination(String name, String jndiName) {
        this.messageDestinations.put(name, jndiName);
    }

    public Map<String, String> getMessageDestinations() {
        return Collections.unmodifiableMap(this.messageDestinations);
    }

    public void addInterceptorEnvironment(String interceptorClassName, InterceptorEnvironment env) {
        this.interceptorEnvironment.put(interceptorClassName, env);
    }

    public Map<String, InterceptorEnvironment> getInterceptorEnvironment() {
        return this.interceptorEnvironment;
    }

    public EEClassIntrospector getClassIntrospector() {
        return this.classIntrospector;
    }

    public void setClassIntrospector(EEClassIntrospector classIntrospector) {
        this.classIntrospector = classIntrospector;
    }
}

