/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    NAME("name"),
    OUTBOUND_SOCKET_BINDING_REF("outbound-socket-binding-ref"),
    SASL_PROTOCOL("sasl-protocol"),
    SECURITY_REALM("security-realm"),
    SERVER_NAME("server-name"),
    SOCKET_BINDING("socket-binding"),
    URI("uri"),
    USERNAME("username"),
    VALUE("value"),
    WORKER_READ_THREADS("read-threads"),
    WORKER_TASK_CORE_THREADS("task-core-threads"),
    WORKER_TASK_KEEPALIVE("task-keepalive"),
    WORKER_TASK_LIMIT("task-limit"),
    WORKER_TASK_MAX_THREADS("task-max-threads"),
    WORKER_WRITE_THREADS("write-threads");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

