/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.config.configprovider.MetaInfResourceProvider;
import com.sun.faces.config.configprovider.RIConfigResourceProvider;
import com.sun.faces.config.configprovider.WebResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final List<ConfigurationResourceProvider> RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final ConfigManager CONFIG_MANAGER;
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private static final ConfigProcessor CONFIG_PROCESSOR_CHAIN;
    private static final String XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";

    public static ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public void initialize(ServletContext servletContext) {
        if (!this.hasBeenInitialized(servletContext)) {
            this.initializedContexts.add(servletContext);
            try {
                CONFIG_PROCESSOR_CHAIN.process(servletContext, ConfigManager.getConfigDocuments(servletContext));
            }
            catch (Exception exception) {
                this.releaseFactories();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unsanitized stacktrace from failed start...", exception);
                }
                Throwable throwable = this.unwind(exception);
                throw new ConfigurationException("CONFIGURATION FAILED! " + throwable.getMessage(), throwable);
            }
        }
    }

    public void destory(ServletContext servletContext) {
        this.releaseFactories();
        this.initializedContexts.remove(servletContext);
    }

    public boolean hasBeenInitialized(ServletContext servletContext) {
        return this.initializedContexts.contains(servletContext);
    }

    private static Document[] getConfigDocuments(ServletContext servletContext) {
        Object interruptedException;
        ArrayList arrayList;
        ExecutorService executorService = null;
        if (ConfigManager.useThreads(servletContext)) {
            executorService = Executors.newFixedThreadPool(5);
        }
        ArrayList<FutureTask<Collection<URL>>> arrayList2 = new ArrayList<FutureTask<Collection<URL>>>(RESOURCE_PROVIDERS.size());
        for (ConfigurationResourceProvider configurationResourceProvider : RESOURCE_PROVIDERS) {
            arrayList = new FutureTask<Collection<URL>>(new URLTask(configurationResourceProvider, servletContext));
            arrayList2.add((FutureTask<Collection<URL>>)((Object)arrayList));
            if (executorService != null) {
                executorService.execute((Runnable)((Object)arrayList));
                continue;
            }
            ((FutureTask)((Object)arrayList)).run();
        }
        ArrayList arrayList3 = new ArrayList(RESOURCE_PROVIDERS.size() << 1);
        boolean bl = WebConfiguration.getInstance(servletContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
        for (FutureTask object22 : arrayList2) {
            try {
                interruptedException = (Collection)object22.get();
                Iterator executionException = interruptedException.iterator();
                while (executionException.hasNext()) {
                    URL uRL = (URL)executionException.next();
                    FutureTask<Document> futureTask = new FutureTask<Document>(new ParseTask(bl, uRL));
                    arrayList3.add(futureTask);
                    if (executorService != null) {
                        executorService.execute(futureTask);
                        continue;
                    }
                    futureTask.run();
                }
            }
            catch (InterruptedException exception) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        arrayList = new ArrayList(arrayList3.size());
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            interruptedException = (FutureTask)iterator.next();
            try {
                arrayList.add(((FutureTask)interruptedException).get());
            }
            catch (ExecutionException interruptedException2) {
                throw new ConfigurationException(interruptedException2);
            }
            catch (InterruptedException interruptedException2) {
            }
        }
        if (executorService != null) {
            executorService.shutdown();
        }
        return arrayList.toArray(new Document[arrayList.size()]);
    }

    private static boolean useThreads(ServletContext servletContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        return webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private Throwable unwind(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null && (throwable2 = this.unwind(throwable.getCause())) == null) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException facesException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", facesException);
            }
        }
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>(3);
        arrayList.add(new RIConfigResourceProvider());
        arrayList.add(new MetaInfResourceProvider());
        arrayList.add(new WebResourceProvider());
        RESOURCE_PROVIDERS = Collections.unmodifiableList(arrayList);
        ConfigProcessor[] configProcessorArray = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor()};
        for (int i = 0; i < configProcessorArray.length; ++i) {
            ConfigProcessor configProcessor = configProcessorArray[i];
            if (i + 1 >= configProcessorArray.length) continue;
            configProcessor.setNext(configProcessorArray[i + 1]);
        }
        CONFIG_PROCESSOR_CHAIN = configProcessorArray[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLTask
    implements Callable<Collection<URL>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URLTask(ConfigurationResourceProvider configurationResourceProvider, ServletContext servletContext) {
            this.provider = configurationResourceProvider;
            this.sc = servletContext;
        }

        @Override
        public Collection<URL> call() throws Exception {
            return this.provider.getResources(this.sc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<Document> {
        private static final String FACES_SCHEMA_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private URL documentURL;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(boolean bl, URL uRL) throws Exception {
            this.documentURL = uRL;
            this.factory = DbfFactory.getFactory();
            this.validating = bl;
        }

        @Override
        public Document call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document document = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURL.toExternalForm());
                }
                return document;
            }
            catch (Exception exception) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURL.toExternalForm(), exception.getMessage()), exception);
            }
        }

        private Document getDocument() throws Exception {
            DocumentBuilder documentBuilder = this.getNonValidatingBuilder();
            InputSource inputSource = new InputSource(ParseTask.getInputStream(this.documentURL));
            inputSource.setSystemId(this.documentURL.toExternalForm());
            Document document = documentBuilder.parse(inputSource);
            String string = document.getDocumentElement().getNamespaceURI();
            if (this.validating && string != null) {
                DOMSource dOMSource = new DOMSource(document, this.documentURL.toExternalForm());
                if (FACES_SCHEMA_DEFAULT_NS.equals(string)) {
                    DocumentBuilder documentBuilder2 = this.getBuilderForSchema(DbfFactory.FacesSchema.FACES_12);
                    if (documentBuilder2.isValidating()) {
                        Util.newValidator(documentBuilder2).validate(dOMSource);
                        return (Document)dOMSource.getNode();
                    }
                    return (Document)dOMSource.getNode();
                }
                DOMResult dOMResult = new DOMResult();
                Transformer transformer = ParseTask.getTransformer();
                transformer.transform(dOMSource, dOMResult);
                DocumentBuilder documentBuilder3 = this.getBuilderForSchema(DbfFactory.FacesSchema.FACES_11);
                if (documentBuilder3.isValidating()) {
                    Util.newValidator(documentBuilder3).validate(dOMSource);
                    return (Document)dOMSource.getNode();
                }
                return (Document)dOMSource.getNode();
            }
            return document;
        }

        private static Transformer getTransformer() throws Exception {
            TransformerFactory transformerFactory = Util.createTransformerFactory();
            return transformerFactory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(ConfigManager.XSL))));
        }

        private static InputStream getInputStream(URL uRL) throws IOException {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            return new BufferedInputStream(uRLConnection.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory documentBuilderFactory = DbfFactory.getFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = Util.newDocumentBuilder(documentBuilderFactory);
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }

        private DocumentBuilder getBuilderForSchema(DbfFactory.FacesSchema facesSchema) throws Exception {
            try {
                this.factory.setSchema(facesSchema.getSchema());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder documentBuilder = Util.newDocumentBuilder(this.factory);
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }
    }
}

