/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LifecycleConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String JS_PHASE_LISTENER = "com.sun.faces.lifecycle.JsfJsResourcePhaseListener";
    private static final String LIFECYCLE = "lifecycle";
    private static final String PHASE_LISTENER = "phase-listener";

    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        for (int i = 0; i < documentArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing lifecycle elements for document: ''{0}''", documentArray[i].getDocumentURI()));
            }
            String string = documentArray[i].getDocumentElement().getNamespaceURI();
            NodeList nodeList = documentArray[i].getDocumentElement().getElementsByTagNameNS(string, LIFECYCLE);
            if (nodeList == null) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                if (node.getNodeType() != 1) continue;
                NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, PHASE_LISTENER);
                this.addPhaseListeners(lifecycleFactory, nodeList2);
            }
        }
        this.invokeNext(servletContext, documentArray);
    }

    private void addPhaseListeners(LifecycleFactory lifecycleFactory, NodeList nodeList) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ExternalizeJavaScript);
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node = nodeList.item(i);
                String string = this.getNodeText(node);
                if (!bl && JS_PHASE_LISTENER.equals(string) || string == null || (object = this.createInstance(string, PhaseListener.class, null, node)) == null) continue;
                Iterator iterator = lifecycleFactory.getLifecycleIds();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Lifecycle lifecycle = lifecycleFactory.getLifecycle(string2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding PhaseListener ''{0}'' to lifecycle ''{0}}", string, string2));
                    }
                    lifecycle.addPhaseListener((PhaseListener)object);
                }
            }
        }
    }
}

