/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String VALIDATOR = "validator";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String VALIDATOR_CLASS = "validator-class";

    public void process(ServletContext servletContext, Document[] documentArray) throws Exception {
        for (int i = 0; i < documentArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing validator elements for document: ''{0}''", documentArray[i].getDocumentURI()));
            }
            String string = documentArray[i].getDocumentElement().getNamespaceURI();
            NodeList nodeList = documentArray[i].getDocumentElement().getElementsByTagNameNS(string, VALIDATOR);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addValidators(nodeList, string);
        }
        this.invokeNext(servletContext, documentArray);
    }

    private void addValidators(NodeList nodeList, String string) throws XPathExpressionException {
        Application application = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                if (VALIDATOR_ID.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (!VALIDATOR_CLASS.equals(node2.getLocalName())) continue;
                string3 = this.getNodeText(node2);
            }
            if (string2 == null || string3 == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addValidator({0},{1})", string2, string3));
            }
            if (verifier != null) {
                verifier.validateObject(Verifier.ObjectType.VALIDATOR, string3, Validator.class);
            }
            application.addValidator(string2, string3);
        }
    }
}

