/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.ApplicationMap;
import com.sun.faces.context.InitParameterMap;
import com.sun.faces.context.RequestCookieMap;
import com.sun.faces.context.RequestHeaderMap;
import com.sun.faces.context.RequestHeaderValuesMap;
import com.sun.faces.context.RequestMap;
import com.sun.faces.context.RequestParameterMap;
import com.sun.faces.context.RequestParameterValuesMap;
import com.sun.faces.context.SessionMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalContextImpl
extends ExternalContext {
    private ServletContext servletContext = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private Map<String, Object> applicationMap = null;
    private Map<String, Object> sessionMap = null;
    private Map<String, Object> requestMap = null;
    private Map<String, String> requestParameterMap = null;
    private Map<String, String[]> requestParameterValuesMap = null;
    private Map<String, String> requestHeaderMap = null;
    private Map<String, String[]> requestHeaderValuesMap = null;
    private Map<String, Object> cookieMap = null;
    private Map<String, String> initParameterMap = null;
    static final Class theUnmodifiableMapClass = Collections.unmodifiableMap(new HashMap()).getClass();

    public ExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        try {
            Util.parameterNonNull(servletContext);
            Util.parameterNonNull(servletRequest);
            Util.parameterNonNull(servletResponse);
        }
        catch (Exception exception) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_CONTEXT_CONSTRUCTION_ERROR", new Object[0]));
        }
        this.servletContext = servletContext;
        this.request = servletRequest;
        this.response = servletResponse;
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        if (webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SendPoweredByHeader)) {
            ((HttpServletResponse)servletResponse).addHeader("X-Powered-By", "JSF/1.2");
        }
    }

    public Object getSession(boolean bl) {
        return ((HttpServletRequest)this.request).getSession(bl);
    }

    public Object getContext() {
        return this.servletContext;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object object) {
        if (object instanceof ServletRequest) {
            this.request = (ServletRequest)object;
            this.requestHeaderMap = null;
            this.requestHeaderValuesMap = null;
            this.requestHeaderValuesMap = null;
            this.requestMap = null;
            this.requestParameterMap = null;
            this.requestParameterValuesMap = null;
        }
    }

    public void setRequestCharacterEncoding(String string) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(string);
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object object) {
        if (object instanceof ServletResponse) {
            this.response = (ServletResponse)object;
        }
    }

    public void setResponseCharacterEncoding(String string) {
        this.response.setCharacterEncoding(string);
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.servletContext);
        }
        return this.applicationMap;
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap((HttpServletRequest)this.request);
        }
        return this.sessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map<String, String> getRequestHeaderMap() {
        if (null == this.requestHeaderMap) {
            this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap((HttpServletRequest)this.request));
        }
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (null == this.requestHeaderValuesMap) {
            this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap((HttpServletRequest)this.request));
        }
        return this.requestHeaderValuesMap;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (null == this.cookieMap) {
            this.cookieMap = Collections.unmodifiableMap(new RequestCookieMap((HttpServletRequest)this.request));
        }
        return this.cookieMap;
    }

    public Map<String, String> getInitParameterMap() {
        if (null == this.initParameterMap) {
            this.initParameterMap = Collections.unmodifiableMap(new InitParameterMap(this.servletContext));
        }
        return this.initParameterMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (null == this.requestParameterMap) {
            this.requestParameterMap = Collections.unmodifiableMap(new RequestParameterMap(this.request));
        }
        return this.requestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (null == this.requestParameterValuesMap) {
            this.requestParameterValuesMap = Collections.unmodifiableMap(new RequestParameterValuesMap(this.request));
        }
        return this.requestParameterValuesMap;
    }

    public Iterator<String> getRequestParameterNames() {
        final Enumeration enumeration = this.request.getParameterNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    public String getRequestPathInfo() {
        return ((HttpServletRequest)this.request).getPathInfo();
    }

    public Cookie[] getRequestCookies() {
        return ((HttpServletRequest)this.request).getCookies();
    }

    public String getRequestContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    public String getRequestServletPath() {
        return ((HttpServletRequest)this.request).getServletPath();
    }

    public String getRequestCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getRequestContentType() {
        return this.request.getContentType();
    }

    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this.response.getContentType();
    }

    public String getInitParameter(String string) {
        return this.servletContext.getInitParameter(string);
    }

    public Set<String> getResourcePaths(String string) {
        return TypedCollections.dynamicallyCastSet(this.servletContext.getResourcePaths(string), String.class);
    }

    public InputStream getResourceAsStream(String string) {
        return this.servletContext.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        URL uRL;
        try {
            uRL = this.servletContext.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return uRL;
    }

    public String encodeActionURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public String encodeResourceURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public String encodeNamespace(String string) {
        return string;
    }

    public String encodeURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public void dispatch(String string) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(string);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this.response).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this.request, this.response);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            throw new FacesException((Throwable)servletException);
        }
    }

    public void redirect(String string) throws IOException {
        ((HttpServletResponse)this.response).sendRedirect(string);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public void log(String string) {
        this.servletContext.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.servletContext.log(string, throwable);
    }

    public String getAuthType() {
        return ((HttpServletRequest)this.request).getAuthType();
    }

    public String getRemoteUser() {
        return ((HttpServletRequest)this.request).getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return ((HttpServletRequest)this.request).getUserPrincipal();
    }

    public boolean isUserInRole(String string) {
        return ((HttpServletRequest)this.request).isUserInRole(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalesIterator
    implements Iterator<Locale> {
        private Enumeration locales;

        public LocalesIterator(Enumeration enumeration) {
            this.locales = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        @Override
        public Locale next() {
            return (Locale)this.locales.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

