/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.Util;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionMap
extends BaseContextMap {
    private final HttpServletRequest request;

    SessionMap(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    @Override
    public void clear() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                httpSession.removeAttribute(string);
            }
        }
    }

    @Override
    public void putAll(Map map) {
        HttpSession httpSession = this.getSession(true);
        for (Map.Entry entry : map.entrySet()) {
            httpSession.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object object) {
        Util.notNull("key", object);
        HttpSession httpSession = this.getSession(false);
        return httpSession != null ? httpSession.getAttribute(object.toString()) : null;
    }

    @Override
    public Object put(Object object, Object object2) {
        Util.notNull("key", object);
        HttpSession httpSession = this.getSession(true);
        Object object3 = httpSession.getAttribute(object.toString());
        httpSession.setAttribute(object.toString(), object2);
        return object3;
    }

    @Override
    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            String string = object.toString();
            Object object2 = httpSession.getAttribute(string);
            httpSession.removeAttribute(string);
            return object2;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null && httpSession.getAttribute(object.toString()) != null;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof SessionMap && super.equals(object);
    }

    private HttpSession getSession(boolean bl) {
        return this.request.getSession(bl);
    }

    @Override
    public int hashCode() {
        HttpSession httpSession = this.getSession(false);
        int n = 7 * (httpSession != null ? httpSession.hashCode() : super.hashCode());
        if (httpSession != null) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
        }
        return n;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null ? new BaseContextMap.EntryIterator(httpSession.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null ? new BaseContextMap.KeyIterator(httpSession.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }

    protected Iterator<Object> getValueIterator() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null ? new BaseContextMap.ValueIterator(httpSession.getAttributeNames()) : Collections.emptyMap().entrySet().iterator();
    }
}

