/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.validator;

import com.sun.faces.ext.validator.MojarraMessageFactory;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 1961950699958181806L;
    private String regex;

    public void setPattern(String string) {
        this.regex = string;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) {
        Locale locale = facesContext.getViewRoot().getLocale();
        if (this.regex == null || this.regex.length() == 0) {
            FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.PATTERN_NOT_SET", new Object[]{null});
            throw new ValidatorException(facesMessage);
        }
        try {
            Pattern pattern = Pattern.compile(this.regex);
            Matcher matcher = pattern.matcher((String)object);
            if (!matcher.matches()) {
                Object[] objectArray = new Object[]{this.regex};
                FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.NOT_MATCHED", objectArray);
                throw new ValidatorException(facesMessage);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.EXP_ERR", new Object[]{null});
            throw new ValidatorException(facesMessage, (Throwable)patternSyntaxException);
        }
    }
}

