/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhase(FacesContext facesContext, Lifecycle lifecycle, ListIterator<PhaseListener> listIterator) {
        Timer timer;
        PhaseEvent phaseEvent = null;
        if (listIterator.hasNext()) {
            phaseEvent = new PhaseEvent(facesContext, this.getId(), lifecycle);
        }
        if ((timer = Timer.getInstance()) != null) {
            timer.startTiming();
        }
        this.handleBeforePhase(facesContext, listIterator, phaseEvent);
        Throwable throwable = null;
        try {
            if (!this.shouldSkip(facesContext)) {
                this.execute(facesContext);
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.lifecycle.phase.exception", new Object[]{this.getId().toString(), facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : "", phaseEvent});
            }
            throwable = exception;
        }
        finally {
            this.handleAfterPhase(facesContext, listIterator, phaseEvent);
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Execution time for phase (including any PhaseListeners) -> " + this.getId().toString());
            }
        }
        if (throwable != null) {
            if (!(throwable instanceof FacesException)) {
                throwable = new FacesException(throwable);
            }
            throw (FacesException)throwable;
        }
    }

    public abstract void execute(FacesContext var1) throws FacesException;

    public abstract PhaseId getId();

    protected void handleAfterPhase(FacesContext facesContext, ListIterator<PhaseListener> listIterator, PhaseEvent phaseEvent) {
        while (listIterator.hasPrevious()) {
            PhaseListener phaseListener = listIterator.previous();
            if (!this.getId().equals(phaseListener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(phaseListener.getPhaseId())) continue;
            try {
                phaseListener.afterPhase(phaseEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "jsf.lifecycle.phaselistener.exception", new Object[]{phaseListener.getClass().getName() + ".afterPhase()", this.getId().toString(), facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : "", exception});
                LOGGER.warning(Util.getStackTraceString(exception));
                return;
            }
        }
    }

    protected void handleBeforePhase(FacesContext facesContext, ListIterator<PhaseListener> listIterator, PhaseEvent phaseEvent) {
        while (listIterator.hasNext()) {
            PhaseListener phaseListener = listIterator.next();
            if (!this.getId().equals(phaseListener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(phaseListener.getPhaseId())) continue;
            try {
                phaseListener.beforePhase(phaseEvent);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.lifecycle.phaselistener.exception", new Object[]{phaseListener.getClass().getName() + ".beforePhase()", this.getId().toString(), facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : "", exception});
                    LOGGER.warning(Util.getStackTraceString(exception));
                }
                if (listIterator.hasPrevious()) {
                    listIterator.previous();
                }
                return;
            }
        }
    }

    private boolean shouldSkip(FacesContext facesContext) {
        if (facesContext.getResponseComplete()) {
            return true;
        }
        return facesContext.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(this.getId());
    }
}

