/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";
    private static final String SUN_JSF_JS = "com.sun.faces.sunJsfJs";
    private static final String OPTIMIZED_PACKAGE = "javax.faces.component.";
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
    protected static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext facesContext) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext facesContext, String string) throws FacesException {
        assert (null != string);
        assert (null != facesContext);
        RenderKit renderKit = facesContext.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory renderKitFactory = (RenderKitFactory)RequestStateManager.get(facesContext, "com.sun.faces.renderKitImplForRequest");
            if (renderKitFactory != null) {
                renderKit = renderKitFactory.getRenderKit(facesContext, string);
            } else {
                renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                if (renderKitFactory == null) {
                    throw new IllegalStateException();
                }
                RequestStateManager.set(facesContext, "com.sun.faces.renderKitImplForRequest", renderKitFactory);
                renderKit = renderKitFactory.getRenderKit(facesContext, string);
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static List<SelectItem> getSelectItems(FacesContext facesContext, UIComponent uIComponent) {
        if (facesContext == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>();
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            Object object;
            Object object2;
            if (uIComponent2 instanceof UISelectItem) {
                object2 = (UISelectItem)uIComponent2;
                object = object2.getValue();
                if (object == null) {
                    arrayList.add(new SelectItem(object2.getItemValue(), object2.getItemLabel(), object2.getItemDescription(), object2.isItemDisabled(), object2.isItemEscaped()));
                    continue;
                }
                if (object instanceof SelectItem) {
                    arrayList.add((SelectItem)object);
                    continue;
                }
                throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", uIComponent.getId(), object.getClass().getName()));
            }
            if (!(uIComponent2 instanceof UISelectItems)) continue;
            object2 = ((UISelectItems)uIComponent2).getValue();
            if (object2 instanceof SelectItem) {
                arrayList.add((SelectItem)object2);
                continue;
            }
            if (object2 instanceof SelectItem[]) {
                object = (SelectItem[])object2;
                for (Object object3 : object) {
                    arrayList.add((SelectItem)object3);
                }
                continue;
            }
            if (object2 instanceof Collection) {
                for (Object e : (Collection)object2) {
                    if (SelectItem.class.isInstance(e)) {
                        arrayList.add((SelectItem)e);
                        continue;
                    }
                    throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", uIComponent.getId(), object2.getClass().getName()));
                }
                continue;
            }
            if (object2 instanceof Map) {
                object = (Map)object2;
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Object object3;
                    Map.Entry entry2 = entry = iterator.next();
                    object3 = entry2.getKey();
                    Object v = entry2.getValue();
                    if (object3 == null || v == null) continue;
                    arrayList.add(new SelectItem(v, object3.toString()));
                }
                continue;
            }
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CHILD_NOT_OF_EXPECTED_TYPE", "UISelectItem/UISelectItems", uIComponent.getFamily(), uIComponent.getId(), object2 != null ? object2.getClass().getName() : "null"));
        }
        return arrayList;
    }

    public static void renderPassThruAttributes(ResponseWriter responseWriter, UIComponent uIComponent, String[] stringArray) throws IOException {
        assert (null != responseWriter);
        assert (null != uIComponent);
        Map map = uIComponent.getAttributes();
        if (RenderKitUtils.canBeOptimized(uIComponent)) {
            List list = (List)uIComponent.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
            if (list != null) {
                RenderKitUtils.renderPassThruAttributesOptimized(responseWriter, uIComponent, stringArray, list);
            }
        } else {
            boolean bl = "application/xhtml+xml".equals(responseWriter.getContentType());
            for (String string : stringArray) {
                Object v = map.get(string);
                if (v == null || !RenderKitUtils.shouldRenderAttribute(v)) continue;
                responseWriter.writeAttribute(RenderKitUtils.prefixAttribute(string, bl), v, string);
            }
        }
    }

    public static String prefixAttribute(String string, ResponseWriter responseWriter) {
        return RenderKitUtils.prefixAttribute(string, "application/xhtml+xml".equals(responseWriter.getContentType()));
    }

    public static String prefixAttribute(String string, boolean bl) {
        if (bl) {
            if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, string) > -1) {
                return XHTML_ATTR_PREFIX + string;
            }
            return string;
        }
        return string;
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        assert (responseWriter != null);
        assert (uIComponent != null);
        Map map = uIComponent.getAttributes();
        for (String string : BOOLEAN_ATTRIBUTES) {
            Object v = map.get(string);
            if (v == null || !Boolean.valueOf(v.toString()).booleanValue()) continue;
            responseWriter.writeAttribute(string, (Object)true, string);
        }
    }

    public static String determineContentType(String string, String string2, String string3) {
        String[][] stringArray;
        String[][] stringArray2;
        String string4 = null;
        if (null == string || null == string2) {
            return string4;
        }
        String[][] stringArray3 = RenderKitUtils.buildTypeArrayFromString(string);
        String[][] stringArray4 = RenderKitUtils.findMatch(stringArray3, stringArray2 = RenderKitUtils.buildTypeArrayFromString(string2), stringArray = RenderKitUtils.buildTypeArrayFromString(string3));
        if (stringArray4[0][1] != null && !stringArray4[0][2].equals("*")) {
            string4 = stringArray4[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + stringArray4[0][2];
        }
        return string4;
    }

    public static boolean isXml(String string) {
        return "application/xhtml+xml".equals(string) || "application/xml".equals(string) || "text/xml".equals(string);
    }

    private static boolean canBeOptimized(UIComponent uIComponent) {
        String string = uIComponent.getClass().getName();
        return string != null && string.startsWith(OPTIMIZED_PACKAGE);
    }

    private static void renderPassThruAttributesOptimized(ResponseWriter responseWriter, UIComponent uIComponent, String[] stringArray, List<String> list) throws IOException {
        Object[] objectArray = list.toArray(new String[list.size()]);
        Arrays.sort(objectArray);
        boolean bl = "application/xhtml+xml".equals(responseWriter.getContentType());
        Map map = uIComponent.getAttributes();
        for (Object object : objectArray) {
            Object v;
            if (Arrays.binarySearch(stringArray, object) < 0 || (v = map.get(object)) == null || !RenderKitUtils.shouldRenderAttribute(v)) continue;
            responseWriter.writeAttribute(RenderKitUtils.prefixAttribute((String)object, bl), v, (String)object);
        }
    }

    private static boolean shouldRenderAttribute(Object object) {
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Boolean && Boolean.FALSE.equals(object)) {
            return false;
        }
        if (object instanceof Integer && (Integer)object == Integer.MIN_VALUE) {
            return false;
        }
        if (object instanceof Double && (Double)object == Double.MIN_VALUE) {
            return false;
        }
        if (object instanceof Character && ((Character)object).charValue() == '\u0000') {
            return false;
        }
        if (object instanceof Float && ((Float)object).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (object instanceof Short && (Short)object == Short.MIN_VALUE) {
            return false;
        }
        if (object instanceof Byte && (Byte)object == -128) {
            return false;
        }
        return !(object instanceof Long) || (Long)object != Long.MIN_VALUE;
    }

    private static String[][] buildTypeArrayFromString(String string) {
        if (string == null || string.length() == 0) {
            return new String[0][0];
        }
        String string2 = null;
        String string3 = null;
        String[] stringArray = Util.split(string, CONTENT_TYPE_DELIMITER);
        String[][] stringArray2 = new String[stringArray.length][4];
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            String string5;
            StringBuilder stringBuilder;
            String[] stringArray3;
            String string6 = stringArray[i].trim();
            ++n;
            if (string6.contains(";")) {
                stringArray3 = Util.split(string6, ";");
                stringBuilder = new StringBuilder(stringArray3[0].trim());
                for (int j = 1; j < stringArray3.length; ++j) {
                    String[] stringArray4;
                    string3 = "not set";
                    string6 = stringArray3[j].trim();
                    if (string6.contains("level")) {
                        stringBuilder.append(';').append(string6);
                        stringArray4 = Util.split(string6, "=");
                        string2 = stringArray4[0].trim();
                        if (!string2.equalsIgnoreCase("level")) continue;
                        string2 = stringArray4[1].trim();
                        continue;
                    }
                    string3 = string6;
                    stringArray4 = Util.split(string3, "=");
                    if ((string3 = stringArray4[0].trim()).equalsIgnoreCase("q")) {
                        string3 = stringArray4[1].trim();
                        break;
                    }
                    string3 = "not set";
                }
            } else {
                stringBuilder = new StringBuilder(string6);
                string3 = "not set";
            }
            if (stringBuilder.indexOf(CONTENT_TYPE_SUBTYPE_DELIMITER) >= 0) {
                stringArray3 = Util.split(stringBuilder.toString(), CONTENT_TYPE_SUBTYPE_DELIMITER);
                if (stringArray3.length == 1) {
                    string5 = stringArray3[0].trim();
                    string4 = "*";
                } else {
                    string5 = stringArray3[0].trim();
                    string4 = stringArray3[1].trim();
                }
            } else {
                string5 = stringBuilder.toString();
                string4 = "";
            }
            if ("not set".equals(string3)) {
                string3 = string5.equals("*") && string4.equals("*") ? "0.01" : (!string5.equals("*") && string4.equals("*") ? "0.02" : (string5.equals("*") && string4.length() == 0 ? "0.01" : "1"));
            }
            stringArray2[n][0] = string3;
            stringArray2[n][1] = string5;
            stringArray2[n][2] = string4;
            stringArray2[n][3] = string2;
        }
        return stringArray2;
    }

    private static String[][] findMatch(String[][] stringArray, String[][] stringArray2, String[][] stringArray3) {
        int n;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray2.length);
        double d = 0.0;
        int n2 = 0;
        int n3 = stringArray2.length;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray2[i][1];
            if (string == null) continue;
            int n4 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                String string2 = stringArray[n][1];
                if (string2 == null || !string2.equalsIgnoreCase(string) && !string2.equals("*") || !stringArray[n][2].equalsIgnoreCase(stringArray2[i][2]) && !stringArray[n][2].equals("*")) continue;
                double d2 = 0.0;
                double d3 = 0.0;
                if (stringArray[n][3] != null) {
                    d2 = Double.parseDouble(stringArray[n][3]) * 0.1;
                }
                if (stringArray2[i][3] != null) {
                    d3 = Double.parseDouble(stringArray2[i][3]) * 0.1;
                }
                double d4 = Double.parseDouble(stringArray[n][0]) + d2;
                double d5 = Double.parseDouble(stringArray2[i][0]) + d3;
                double d6 = d4 * d5;
                String[] stringArray4 = new String[4];
                arrayList.add(stringArray4);
                stringArray4[0] = String.valueOf(d6);
                if (stringArray[n][2].equals("*")) {
                    stringArray4[1] = stringArray[n][1];
                    stringArray4[2] = stringArray[n][2];
                } else {
                    stringArray4[1] = stringArray2[i][1];
                    stringArray4[2] = stringArray2[i][2];
                    stringArray4[3] = stringArray2[i][3];
                }
                if (!(d6 > d)) continue;
                n2 = arrayList.size() - 1;
                d = d6;
            }
        }
        String[][] stringArray5 = new String[1][3];
        if (stringArray3.length != 0 && stringArray3[0][0] != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d);
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray6 = (String[])arrayList.get(i);
                if (BigDecimal.valueOf(Double.parseDouble(stringArray6[0])).compareTo(bigDecimal) != 0 || !stringArray6[1].equals(stringArray3[0][1]) || !stringArray6[2].equals(stringArray3[0][2])) continue;
                stringArray5[0][0] = stringArray6[0];
                stringArray5[0][1] = stringArray6[1];
                stringArray5[0][2] = stringArray6[2];
                return stringArray5;
            }
        }
        if (!arrayList.isEmpty()) {
            String[] stringArray7 = (String[])arrayList.get(n2);
            stringArray5[0][0] = stringArray7[0];
            stringArray5[0][1] = stringArray7[1];
            stringArray5[0][2] = stringArray7[2];
        }
        return stringArray5;
    }

    public static String createValidECMAIdentifier(String string) {
        return string.replace("-", "$_");
    }

    public static void renderFormInitScript(ResponseWriter responseWriter, FacesContext facesContext) throws IOException {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(facesContext.getExternalContext());
        if (webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ExternalizeJavaScript)) {
            String string = Util.getFacesMapping(facesContext);
            String string2 = string != null && Util.isPrefixMapped(string) ? string + '/' + "com_sun_faces_sunjsf.js" : "/com_sun_faces_sunjsf.js" + string;
            responseWriter.write(10);
            responseWriter.startElement("script", null);
            responseWriter.writeAttribute("type", (Object)"text/javascript", null);
            responseWriter.writeAttribute("src", (Object)(facesContext.getExternalContext().getRequestContextPath() + string2), null);
            responseWriter.endElement("script");
            responseWriter.write("\n");
        } else {
            responseWriter.write(10);
            responseWriter.startElement("script", null);
            responseWriter.writeAttribute("type", (Object)"text/javascript", null);
            responseWriter.writeAttribute("language", (Object)"Javascript", null);
            RenderKitUtils.writeSunJS(facesContext, (Writer)responseWriter);
            responseWriter.endElement("script");
            responseWriter.write("\n");
        }
    }

    public static String getCommandLinkOnClickScript(String string, String string2, String string3, HtmlBasicRenderer.Param[] paramArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("if(typeof jsfcljs == 'function'){jsfcljs(document.getElementById('");
        stringBuilder.append(string);
        stringBuilder.append("'),{'");
        stringBuilder.append(string2).append("':'").append(string2);
        for (HtmlBasicRenderer.Param param : paramArray) {
            String string4 = param.name;
            if (string4 == null || string4.length() == 0) continue;
            String string5 = param.value;
            stringBuilder.append("','");
            stringBuilder.append(string4.replace("'", "\\'"));
            stringBuilder.append("':'");
            if (string5 == null || string5.length() == 0) continue;
            stringBuilder.append(string5.replace("'", "\\'"));
        }
        stringBuilder.append("'},'");
        stringBuilder.append(string3);
        stringBuilder.append("');}return false");
        return stringBuilder.toString();
    }

    public static char[] compressJS(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        StringWriter stringWriter = new StringWriter(1024);
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string2 = string2.trim();
                stringWriter.write(string2);
                string2 = bufferedReader.readLine();
            }
            return stringWriter.toString().toCharArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void writeSunJS(FacesContext facesContext, Writer writer) throws IOException {
        writer.write((char[])facesContext.getExternalContext().getApplicationMap().get(SUN_JSF_JS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadSunJsfJs(ExternalContext externalContext) {
        Map map = externalContext.getApplicationMap();
        BufferedReader bufferedReader = null;
        try {
            URL uRL = RenderKitUtils.class.getClassLoader().getResource("com/sun/faces/sunjsf.js");
            if (uRL == null) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("jsf.renderkit.util.cannot_load_js");
                }
                return;
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder(128);
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = string.trim();
                if (!(string2.length() == 0 || string2.startsWith("/*") || string2.startsWith("*") || string2.startsWith("*/") || string2.startsWith("//"))) {
                    stringBuilder.append(string).append('\n');
                }
                string = bufferedReader.readLine();
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            char[] cArray = WebConfiguration.getInstance(externalContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressJavaScript) ? RenderKitUtils.compressJS(stringBuilder.toString()) : stringBuilder.toString().toCharArray();
            map.put(SUN_JSF_JS, cArray);
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.renderkit.util.cannot_load_js", iOException);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

