/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    private static final char[] STATE_FIELD_START_NO_ID = "<input type=\"hidden\" name=\"javax.faces.ViewState\" value=\"".toCharArray();
    private static final char[] STATE_FIELD_END = "\" />".toCharArray();
    private static final char[] STATE_FIELD_AUTOCOMPLETE_END = "\" autocomplete=\"off\" />".toCharArray();
    private char[] stateFieldStart;
    private char[] stateFieldEnd;
    private SerializationProvider serialProvider;
    private WebConfiguration webConfig;
    private Boolean compressState;
    private ByteArrayGuard guard;
    private int csBuffSize;

    public ResponseStateManagerImpl() {
        this.init();
    }

    public Object getComponentStateToRestore(FacesContext facesContext) {
        return RequestStateManager.get(facesContext, "com.sun.faces.FACES_VIEW_STATE");
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestParameterMap().containsKey("javax.faces.ViewState");
    }

    public Object getTreeStructureToRestore(FacesContext facesContext, String string) {
        Object object = RequestStateManager.get(facesContext, "com.sun.faces.FACES_VIEW_STRUCTURE");
        if (object != null) {
            return object;
        }
        StateManager stateManager = Util.getStateManager(facesContext);
        String string2 = ResponseStateManagerImpl.getStateParam(facesContext);
        if (string2 == null) {
            return null;
        }
        if (stateManager.isSavingStateInClient(facesContext)) {
            Object object2;
            ObjectInputStream objectInputStream = null;
            try {
                InputStream inputStream = this.compressState != false ? new GZIPInputStream(new Base64InputStream(string2)) : new Base64InputStream(string2);
                objectInputStream = this.guard != null ? this.serialProvider.createObjectInputStream(new CipherInputStream(inputStream, this.guard.getDecryptionCipher())) : this.serialProvider.createObjectInputStream(inputStream);
                long l = 0L;
                if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
                    try {
                        l = objectInputStream.readLong();
                    }
                    catch (IOException iOException) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                        }
                        Object var11_14 = null;
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        return var11_14;
                    }
                }
                Object object3 = objectInputStream.readObject();
                Object object4 = objectInputStream.readObject();
                if (l != 0L && this.hasStateExpired(l)) {
                    Object var12_17 = null;
                    return var12_17;
                }
                ResponseStateManagerImpl.storeStateInRequest(facesContext, object4);
                ResponseStateManagerImpl.storeStructureInRequest(facesContext, object3);
                object2 = object3;
            }
            catch (OptionalDataException optionalDataException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, optionalDataException.getMessage(), optionalDataException);
                }
                throw new FacesException((Throwable)optionalDataException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
                }
                throw new FacesException((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                }
                throw new FacesException((Throwable)iOException);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return object2;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void writeState(FacesContext var1_1, StateManager.SerializedView var2_2) throws IOException {
        var3_3 = Util.getStateManager(var1_1);
        var4_4 = var1_1.getResponseWriter();
        var4_4.write(this.stateFieldStart);
        if (var3_3.isSavingStateInClient(var1_1)) {
            var5_5 = null;
            try {
                var6_6 = new Base64OutputStreamWriter(this.csBuffSize, (Writer)var4_4);
                var7_8 /* !! */  = this.compressState != false ? new GZIPOutputStream((OutputStream)var6_6, 1024) : var6_6;
                var5_5 = this.guard != null ? this.serialProvider.createObjectOutputStream(new BufferedOutputStream(new CipherOutputStream(var7_8 /* !! */ , this.guard.getEncryptionCipher()))) : this.serialProvider.createObjectOutputStream(new BufferedOutputStream(var7_8 /* !! */ , 1024));
                if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
                    var5_5.writeLong(System.currentTimeMillis());
                }
                var5_5.writeObject(var2_2.getStructure());
                var5_5.writeObject(var2_2.getState());
                var5_5.flush();
                var5_5.close();
                var6_6.finish();
                if (!ResponseStateManagerImpl.LOGGER.isLoggable(Level.FINE)) ** GOTO lbl28
                ResponseStateManagerImpl.LOGGER.fine("Client State: total number of characters written: " + var6_6.getTotalCharsWritten());
            }
            finally {
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (IOException var6_7) {}
                }
            }
        } else {
            var4_4.write(var2_2.getStructure().toString());
        }
lbl28:
        // 3 sources

        var4_4.write(this.stateFieldEnd);
        ResponseStateManagerImpl.writeRenderKitIdField(var1_1, var4_4);
    }

    private boolean hasStateExpired(long l) {
        if (this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout)) {
            int n;
            long l2 = (System.currentTimeMillis() - l) / 60000L;
            return l2 > (long)(n = Integer.parseInt(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout)));
        }
        return false;
    }

    private static void storeStateInRequest(FacesContext facesContext, Object object) {
        RequestStateManager.set(facesContext, "com.sun.faces.FACES_VIEW_STATE", object);
    }

    private static void storeStructureInRequest(FacesContext facesContext, Object object) {
        RequestStateManager.set(facesContext, "com.sun.faces.FACES_VIEW_STRUCTURE", object);
    }

    private static void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String string = facesContext.getApplication().getDefaultRenderKitId();
        if (string != null && !"HTML_BASIC".equals(string)) {
            responseWriter.startElement("input", (UIComponent)facesContext.getViewRoot());
            responseWriter.writeAttribute("type", (Object)"hidden", "type");
            responseWriter.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            responseWriter.writeAttribute("value", (Object)string, "value");
            responseWriter.endElement("input");
        }
    }

    private static String getStateParam(FacesContext facesContext) {
        String string = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private void init() {
        this.webConfig = WebConfiguration.getInstance();
        assert (this.webConfig != null);
        String string = this.webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ClientStateSavingPassword);
        if (string != null) {
            this.guard = new ByteArrayGuard(string);
        }
        this.compressState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        String string2 = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String string3 = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(string2);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string2, string3});
                }
                this.csBuffSize = Integer.parseInt(string3);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string2, string3});
            }
            this.csBuffSize = Integer.parseInt(string3);
        }
        this.stateFieldStart = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering) ? STATE_FIELD_START : STATE_FIELD_START_NO_ID;
        char[] cArray = this.stateFieldEnd = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState) ? STATE_FIELD_AUTOCOMPLETE_END : STATE_FIELD_END;
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(FacesContext.getCurrentInstance().getExternalContext());
        }
    }
}

