/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class GridRenderer
extends BaseTableRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.PANELGRID);

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        this.renderTableStart(facesContext, uIComponent, responseWriter, ATTRIBUTES);
        this.renderCaption(facesContext, uIComponent, responseWriter);
        this.renderHeader(facesContext, uIComponent, responseWriter);
        this.renderFooter(facesContext, uIComponent, responseWriter);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncodeChildren(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        int n = tableMetaInfo.columns.size();
        boolean bl = false;
        int n2 = 0;
        this.renderTableBodyStart(facesContext, uIComponent, responseWriter);
        Iterator<UIComponent> iterator = this.getChildren(uIComponent);
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = iterator.next();
            if (!uIComponent2.isRendered()) continue;
            if (n2 % n == 0) {
                if (bl) {
                    this.renderRowEnd(facesContext, uIComponent, responseWriter);
                    bl = false;
                }
                this.renderRowStart(facesContext, uIComponent, responseWriter);
                bl = true;
                tableMetaInfo.newRow();
            }
            this.renderRow(facesContext, uIComponent, uIComponent2, responseWriter);
            ++n2;
        }
        if (bl) {
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
        }
        this.renderTableBodyEnd(facesContext, uIComponent, responseWriter);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        this.renderTableEnd(facesContext, uIComponent, facesContext.getResponseWriter());
        this.clearMetaInfo(facesContext, uIComponent);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderRow(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        responseWriter.startElement("td", uIComponent);
        String string = tableMetaInfo.getCurrentColumnClass();
        if (string != null) {
            responseWriter.writeAttribute("class", (Object)string, "columns");
        }
        this.encodeRecursive(facesContext, uIComponent2);
        responseWriter.endElement("td");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    protected void renderHeader(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        UIComponent uIComponent2 = this.getFacet(uIComponent, "header");
        String string = (String)uIComponent.getAttributes().get("headerClass");
        if (uIComponent2 != null) {
            responseWriter.startElement("thead", uIComponent);
            responseWriter.writeText((Object)"\n", uIComponent, null);
            responseWriter.startElement("tr", uIComponent2);
            responseWriter.startElement("th", uIComponent2);
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "headerClass");
            }
            responseWriter.writeAttribute("colspan", (Object)String.valueOf(tableMetaInfo.columns.size()), null);
            responseWriter.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(facesContext, uIComponent2);
            responseWriter.endElement("th");
            responseWriter.endElement("tr");
            responseWriter.writeText((Object)"\n", uIComponent, null);
            responseWriter.endElement("thead");
            responseWriter.writeText((Object)"\n", uIComponent, null);
        }
    }

    protected void renderFooter(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        UIComponent uIComponent2 = this.getFacet(uIComponent, "footer");
        String string = (String)uIComponent.getAttributes().get("footerClass");
        if (uIComponent2 != null) {
            responseWriter.startElement("tfoot", uIComponent);
            responseWriter.writeText((Object)"\n", uIComponent, null);
            responseWriter.startElement("tr", uIComponent2);
            responseWriter.startElement("td", uIComponent2);
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "footerClass");
            }
            responseWriter.writeAttribute("colspan", (Object)String.valueOf(tableMetaInfo.columns.size()), null);
            this.encodeRecursive(facesContext, uIComponent2);
            responseWriter.endElement("td");
            responseWriter.endElement("tr");
            responseWriter.writeText((Object)"\n", uIComponent, null);
            responseWriter.endElement("tfoot");
            responseWriter.writeText((Object)"\n", uIComponent, null);
        }
    }
}

