/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class DebugUtil {
    private static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void setKeepWaiting(boolean bl) {
        keepWaiting = bl;
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + interruptedException.getMessage());
            }
        }
    }

    private static void indentPrintln(Writer writer, String string) {
        try {
            for (int i = 0; i < curDepth; ++i) {
                writer.write("  ");
            }
            writer.write(string + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String printTree(UIComponent uIComponent) {
        FastStringWriter fastStringWriter = new FastStringWriter(1024);
        DebugUtil.printTree(uIComponent, (Writer)fastStringWriter);
        return ((Object)fastStringWriter).toString();
    }

    public static void printTree(UIComponent uIComponent, PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        DebugUtil.printTree(uIComponent, (Writer)printWriter);
        printWriter.flush();
    }

    public static void printTree(UIComponent uIComponent, Logger logger, Level level) {
        StringWriter stringWriter = new StringWriter();
        DebugUtil.printTree(uIComponent, (Writer)stringWriter);
        logger.log(level, stringWriter.toString());
    }

    public static void printTree(UIComponent uIComponent, Writer writer) {
        Object object4;
        Iterator<Object> iterator;
        Object object2;
        if (null == uIComponent) {
            return;
        }
        Object object3 = null;
        DebugUtil.indentPrintln(writer, "id:" + uIComponent.getId());
        DebugUtil.indentPrintln(writer, "type:" + uIComponent.getClass().getName());
        if (uIComponent instanceof UISelectOne) {
            object2 = null;
            try {
                object2 = RenderKitUtils.getSelectItems(FacesContext.getCurrentInstance(), uIComponent);
            }
            catch (Exception exception) {
                DebugUtil.indentPrintln(writer, " { SelectItem(s) not resolvable at this point in time }");
            }
            if (object2 != null) {
                DebugUtil.indentPrintln(writer, " {");
                if (!object2.isEmpty()) {
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object4 = (SelectItem)iterator.next();
                        DebugUtil.indentPrintln(writer, "\t value = " + object4.getValue() + ", label = " + object4.getLabel() + ", description = " + object4.getDescription());
                    }
                }
                DebugUtil.indentPrintln(writer, " }");
            }
        } else {
            object2 = null;
            if (uIComponent instanceof ValueHolder) {
                object2 = uIComponent.getValueExpression("value");
                try {
                    object3 = ((ValueHolder)uIComponent).getValue();
                }
                catch (Exception exception) {
                    object3 = "UNAVAILABLE";
                }
            }
            if (object2 != null) {
                DebugUtil.indentPrintln(writer, "expression/value = " + object2.getExpressionString() + " : " + object3);
            } else {
                DebugUtil.indentPrintln(writer, "value = " + object3);
            }
            iterator = uIComponent.getAttributes().keySet().iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String string;
                    object4 = (String)iterator.next();
                    object2 = uIComponent.getValueExpression((String)object4);
                    String string2 = null;
                    if (object2 != null) {
                        string2 = object2.getExpressionString();
                    }
                    try {
                        string = uIComponent.getAttributes().get(object4).toString();
                    }
                    catch (Exception exception) {
                        string = "UNAVAILABLE";
                    }
                    if (string2 != null) {
                        DebugUtil.indentPrintln(writer, "attr = " + (String)object4 + " : [" + string2 + " : " + string + " ]");
                        continue;
                    }
                    DebugUtil.indentPrintln(writer, "attr = " + (String)object4 + " : " + string);
                }
            }
        }
        ++curDepth;
        object2 = uIComponent.getChildren().iterator();
        for (Object object4 : uIComponent.getFacets().values()) {
            DebugUtil.printTree((UIComponent)object4, writer);
        }
        while (object2.hasNext()) {
            DebugUtil.printTree((UIComponent)object2.next(), writer);
        }
        --curDepth;
    }

    public static void simplePrintTree(UIComponent uIComponent, String string, Writer writer) {
        if (null == uIComponent) {
            return;
        }
        if (string.equals(uIComponent.getId())) {
            DebugUtil.indentPrintln(writer, "+id: " + uIComponent.getId() + "  <===============");
        } else {
            DebugUtil.indentPrintln(writer, "+id: " + uIComponent.getId());
        }
        DebugUtil.indentPrintln(writer, " type: " + uIComponent.toString());
        ++curDepth;
        for (UIComponent uIComponent2 : uIComponent.getFacets().values()) {
            DebugUtil.simplePrintTree(uIComponent2, string, writer);
        }
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            DebugUtil.simplePrintTree(uIComponent2, string, writer);
        }
        --curDepth;
    }

    public static void printTree(Object[] objectArray, Writer writer) {
        if (null == objectArray) {
            DebugUtil.indentPrintln(writer, "null");
            return;
        }
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        while (!bl) {
            Object object = objectArray2[0];
            bl = !object.getClass().isArray();
            if (bl) continue;
            objectArray2 = (Object[])object;
        }
        DebugUtil.indentPrintln(writer, "type:" + objectArray2[8]);
        ++curDepth;
        objectArray = (Object[])objectArray[1];
        for (int i = 0; i < objectArray.length; ++i) {
            DebugUtil.printTree((Object[])objectArray[i], writer);
        }
        --curDepth;
    }
}

