/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.Operation;

public class KeyOperationFactory {
    public static List<KeyOperation> generatePOSIXEmacsMode() {
        List<KeyOperation> keys = KeyOperationFactory.generateGenericEmacsKeys();
        keys.add(new KeyOperation(10, Operation.NEW_LINE));
        keys.add(new KeyOperation(31, Operation.UNDO));
        keys.add(new KeyOperation(127, Operation.DELETE_PREV_CHAR));
        keys.add(new KeyOperation(new int[]{27, 91, 65}, Operation.HISTORY_PREV));
        keys.add(new KeyOperation(new int[]{27, 91, 66}, Operation.HISTORY_NEXT));
        keys.add(new KeyOperation(new int[]{27, 91, 67}, Operation.MOVE_NEXT_CHAR));
        keys.add(new KeyOperation(new int[]{27, 91, 68}, Operation.MOVE_PREV_CHAR));
        keys.add(new KeyOperation(new int[]{27, 79, 65}, Operation.HISTORY_PREV));
        keys.add(new KeyOperation(new int[]{27, 79, 66}, Operation.HISTORY_NEXT));
        keys.add(new KeyOperation(new int[]{27, 79, 67}, Operation.MOVE_NEXT_CHAR));
        keys.add(new KeyOperation(new int[]{27, 79, 68}, Operation.MOVE_PREV_CHAR));
        keys.add(new KeyOperation(new int[]{27, 102}, Operation.MOVE_NEXT_WORD));
        keys.add(new KeyOperation(new int[]{27, 98}, Operation.MOVE_PREV_WORD));
        keys.add(new KeyOperation(new int[]{27, 100}, Operation.DELETE_NEXT_WORD));
        keys.add(new KeyOperation(new int[]{27, 91, 51, 126}, Operation.DELETE_NEXT_CHAR));
        keys.add(new KeyOperation(new int[]{27, 91, 53, 126}, Operation.PGUP));
        keys.add(new KeyOperation(new int[]{27, 91, 54, 126}, Operation.PGDOWN));
        keys.add(new KeyOperation(new int[]{27, 10}, Operation.VI_EDIT_MODE));
        return keys;
    }

    public static List<KeyOperation> generateWindowsEmacsMode() {
        List<KeyOperation> keys = KeyOperationFactory.generateGenericEmacsKeys();
        keys.add(new KeyOperation(8, Operation.DELETE_PREV_CHAR));
        keys.add(new KeyOperation(13, Operation.NEW_LINE));
        keys.add(new KeyOperation(new int[]{224, 72}, Operation.HISTORY_PREV));
        keys.add(new KeyOperation(new int[]{224, 80}, Operation.HISTORY_NEXT));
        keys.add(new KeyOperation(new int[]{224, 77}, Operation.MOVE_NEXT_CHAR));
        keys.add(new KeyOperation(new int[]{224, 75}, Operation.MOVE_PREV_CHAR));
        keys.add(new KeyOperation(new int[]{0, 33}, Operation.MOVE_NEXT_WORD));
        keys.add(new KeyOperation(new int[]{0, 48}, Operation.MOVE_PREV_WORD));
        keys.add(new KeyOperation(new int[]{0, 32}, Operation.DELETE_NEXT_WORD));
        keys.add(new KeyOperation(new int[]{224, 83}, Operation.DELETE_NEXT_CHAR));
        keys.add(new KeyOperation(new int[]{224, 73}, Operation.PGUP));
        keys.add(new KeyOperation(new int[]{224, 81}, Operation.PGDOWN));
        keys.add(new KeyOperation(new int[]{224, 71}, Operation.MOVE_BEGINNING));
        keys.add(new KeyOperation(new int[]{224, 79}, Operation.MOVE_END));
        keys.add(new KeyOperation(new int[]{0, 36}, Operation.VI_EDIT_MODE));
        return keys;
    }

    private static List<KeyOperation> generateGenericEmacsKeys() {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        ArrayList<KeyOperation> keys = new ArrayList<KeyOperation>();
        keys.add(new KeyOperation(1, Operation.MOVE_BEGINNING));
        keys.add(new KeyOperation(2, Operation.MOVE_PREV_CHAR));
        keys.add(new KeyOperation(3, Operation.EXIT));
        keys.add(new KeyOperation(4, Operation.EXIT));
        keys.add(new KeyOperation(5, Operation.MOVE_END));
        keys.add(new KeyOperation(6, Operation.MOVE_NEXT_CHAR));
        keys.add(new KeyOperation(7, Operation.ABORT));
        keys.add(new KeyOperation(8, Operation.DELETE_PREV_CHAR));
        keys.add(new KeyOperation(9, Operation.COMPLETE));
        keys.add(new KeyOperation(11, Operation.DELETE_END));
        keys.add(new KeyOperation(12, Operation.CLEAR));
        keys.add(new KeyOperation(14, Operation.HISTORY_NEXT));
        keys.add(new KeyOperation(16, Operation.HISTORY_PREV));
        keys.add(new KeyOperation(18, Operation.SEARCH_PREV));
        keys.add(new KeyOperation(19, Operation.SEARCH_NEXT_WORD));
        keys.add(new KeyOperation(21, Operation.DELETE_BEGINNING));
        keys.add(new KeyOperation(22, Operation.PASTE_FROM_CLIPBOARD));
        keys.add(new KeyOperation(23, Operation.DELETE_PREV_BIG_WORD));
        keys.add(new KeyOperation(25, Operation.PASTE_BEFORE));
        keys.add(new KeyOperation(new int[]{24, 21}, Operation.UNDO));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray6 = new int[3];
            nArray6[0] = 27;
            nArray6[1] = 79;
            nArray5 = nArray6;
            nArray6[2] = 72;
        } else {
            int[] nArray7 = new int[2];
            nArray7[0] = 224;
            nArray5 = nArray7;
            nArray7[1] = 71;
        }
        keys.add(new KeyOperation(nArray5, Operation.MOVE_BEGINNING));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray8 = new int[3];
            nArray8[0] = 27;
            nArray8[1] = 91;
            nArray4 = nArray8;
            nArray8[2] = 72;
        } else {
            int[] nArray9 = new int[2];
            nArray9[0] = 224;
            nArray4 = nArray9;
            nArray9[1] = 71;
        }
        keys.add(new KeyOperation(nArray4, Operation.MOVE_BEGINNING));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray10 = new int[3];
            nArray10[0] = 27;
            nArray10[1] = 79;
            nArray3 = nArray10;
            nArray10[2] = 70;
        } else {
            int[] nArray11 = new int[2];
            nArray11[0] = 224;
            nArray3 = nArray11;
            nArray11[1] = 79;
        }
        keys.add(new KeyOperation(nArray3, Operation.MOVE_END));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray12 = new int[3];
            nArray12[0] = 27;
            nArray12[1] = 91;
            nArray2 = nArray12;
            nArray12[2] = 70;
        } else {
            int[] nArray13 = new int[2];
            nArray13[0] = 224;
            nArray2 = nArray13;
            nArray13[1] = 79;
        }
        keys.add(new KeyOperation(nArray2, Operation.MOVE_END));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray14 = new int[4];
            nArray14[0] = 27;
            nArray14[1] = 91;
            nArray14[2] = 50;
            nArray = nArray14;
            nArray14[3] = 126;
        } else {
            int[] nArray15 = new int[2];
            nArray15[0] = 224;
            nArray = nArray15;
            nArray15[1] = 82;
        }
        keys.add(new KeyOperation(nArray, Operation.NO_ACTION));
        return keys;
    }

    public static List<KeyOperation> generatePOSIXViMode() {
        List<KeyOperation> keys = KeyOperationFactory.generateGenericViMode();
        keys.add(new KeyOperation(10, Operation.NEW_LINE));
        keys.add(new KeyOperation(new int[]{27, 91, 65}, Operation.HISTORY_PREV, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 91, 66}, Operation.HISTORY_NEXT, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 91, 67}, Operation.MOVE_NEXT_CHAR, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 91, 68}, Operation.MOVE_PREV_CHAR, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 79, 65}, Operation.HISTORY_PREV, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 79, 66}, Operation.HISTORY_NEXT, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 79, 67}, Operation.MOVE_NEXT_CHAR, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 79, 68}, Operation.MOVE_PREV_CHAR, Action.EDIT));
        keys.add(new KeyOperation(new int[]{27, 91, 51, 126}, Operation.DELETE_NEXT_CHAR, Action.COMMAND));
        keys.add(new KeyOperation(new int[]{27, 91, 53, 126}, Operation.PGUP));
        keys.add(new KeyOperation(new int[]{27, 91, 54, 126}, Operation.PGDOWN));
        return keys;
    }

    public static List<KeyOperation> generateWindowsViMode() {
        List<KeyOperation> keys = KeyOperationFactory.generateGenericViMode();
        keys.add(new KeyOperation(13, Operation.NEW_LINE));
        keys.add(new KeyOperation(new int[]{224, 83}, Operation.DELETE_NEXT_CHAR, Action.COMMAND));
        keys.add(new KeyOperation(new int[]{224, 73}, Operation.PGUP));
        keys.add(new KeyOperation(new int[]{224, 81}, Operation.PGDOWN));
        return keys;
    }

    private static List<KeyOperation> generateGenericViMode() {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        ArrayList<KeyOperation> keys = new ArrayList<KeyOperation>();
        keys.add(new KeyOperation(3, Operation.EXIT));
        keys.add(new KeyOperation(4, Operation.EXIT));
        keys.add(new KeyOperation(5, Operation.EMACS_EDIT_MODE));
        keys.add(new KeyOperation(9, Operation.COMPLETE));
        keys.add(new KeyOperation(12, Operation.CLEAR));
        keys.add(new KeyOperation(18, Operation.SEARCH_PREV));
        keys.add(new KeyOperation(27, Operation.ESCAPE));
        keys.add(new KeyOperation(115, Operation.CHANGE_NEXT_CHAR));
        keys.add(new KeyOperation(83, Operation.CHANGE_ALL));
        keys.add(new KeyOperation(100, Operation.DELETE_ALL));
        keys.add(new KeyOperation(68, Operation.DELETE_END));
        keys.add(new KeyOperation(99, Operation.CHANGE));
        keys.add(new KeyOperation(67, Operation.CHANGE_END));
        keys.add(new KeyOperation(97, Operation.MOVE_NEXT_CHAR));
        keys.add(new KeyOperation(65, Operation.MOVE_END));
        keys.add(new KeyOperation(48, Operation.BEGINNING));
        keys.add(new KeyOperation(36, Operation.END));
        keys.add(new KeyOperation(120, Operation.DELETE_NEXT_CHAR));
        keys.add(new KeyOperation(88, Operation.DELETE_PREV_CHAR, Action.COMMAND));
        keys.add(new KeyOperation(112, Operation.PASTE_AFTER));
        keys.add(new KeyOperation(80, Operation.PASTE_BEFORE));
        keys.add(new KeyOperation(105, Operation.INSERT));
        keys.add(new KeyOperation(73, Operation.INSERT_BEGINNING));
        keys.add(new KeyOperation(126, Operation.CASE));
        keys.add(new KeyOperation(121, Operation.YANK_ALL));
        keys.add(new KeyOperation(114, Operation.REPLACE));
        keys.add(new KeyOperation(104, Operation.PREV_CHAR));
        keys.add(new KeyOperation(108, Operation.NEXT_CHAR));
        keys.add(new KeyOperation(106, Operation.HISTORY_NEXT));
        keys.add(new KeyOperation(107, Operation.HISTORY_PREV));
        keys.add(new KeyOperation(98, Operation.PREV_WORD));
        keys.add(new KeyOperation(66, Operation.PREV_BIG_WORD));
        keys.add(new KeyOperation(119, Operation.NEXT_WORD));
        keys.add(new KeyOperation(87, Operation.NEXT_BIG_WORD));
        keys.add(new KeyOperation(32, Operation.NEXT_CHAR));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray6 = new int[3];
            nArray6[0] = 27;
            nArray6[1] = 79;
            nArray5 = nArray6;
            nArray6[2] = 72;
        } else {
            int[] nArray7 = new int[2];
            nArray7[0] = 224;
            nArray5 = nArray7;
            nArray7[1] = 71;
        }
        keys.add(new KeyOperation(nArray5, Operation.MOVE_BEGINNING, Action.EDIT));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray8 = new int[3];
            nArray8[0] = 27;
            nArray8[1] = 91;
            nArray4 = nArray8;
            nArray8[2] = 72;
        } else {
            int[] nArray9 = new int[2];
            nArray9[0] = 224;
            nArray4 = nArray9;
            nArray9[1] = 71;
        }
        keys.add(new KeyOperation(nArray4, Operation.MOVE_BEGINNING, Action.EDIT));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray10 = new int[3];
            nArray10[0] = 27;
            nArray10[1] = 79;
            nArray3 = nArray10;
            nArray10[2] = 70;
        } else {
            int[] nArray11 = new int[2];
            nArray11[0] = 224;
            nArray3 = nArray11;
            nArray11[1] = 79;
        }
        keys.add(new KeyOperation(nArray3, Operation.MOVE_END, Action.EDIT));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray12 = new int[3];
            nArray12[0] = 27;
            nArray12[1] = 91;
            nArray2 = nArray12;
            nArray12[2] = 70;
        } else {
            int[] nArray13 = new int[2];
            nArray13[0] = 224;
            nArray2 = nArray13;
            nArray13[1] = 79;
        }
        keys.add(new KeyOperation(nArray2, Operation.MOVE_END, Action.EDIT));
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray14 = new int[4];
            nArray14[0] = 27;
            nArray14[1] = 91;
            nArray14[2] = 50;
            nArray = nArray14;
            nArray14[3] = 126;
        } else {
            int[] nArray15 = new int[2];
            nArray15[0] = 224;
            nArray = nArray15;
            nArray15[1] = 82;
        }
        keys.add(new KeyOperation(nArray, Operation.NO_ACTION));
        keys.add(new KeyOperation(46, Operation.REPEAT));
        keys.add(new KeyOperation(117, Operation.UNDO));
        keys.add(new KeyOperation(127, Operation.DELETE_PREV_CHAR));
        return keys;
    }

    public static boolean containNewLine(int[] input) {
        int newLine = KeyOperationFactory.getNewLine();
        for (int i : input) {
            if (i != newLine) continue;
            return true;
        }
        return false;
    }

    public static int getNewLine() {
        return Config.isOSPOSIXCompatible() ? 10 : 13;
    }
}

