/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class EchoVariableHandler
extends CommandHandlerWithHelp {
    public EchoVariableHandler() {
        super("echo");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        List<String> values = ctx.getParsedCommandLine().getOtherProperties();
        ctx.printColumns(values);
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        Set<String> propertyNames = args.getPropertyNames();
        if (!propertyNames.isEmpty()) {
            Collection<String> names;
            if (this.helpArg.isPresent(args)) {
                if (propertyNames.size() == 1) {
                    return;
                }
                names = new ArrayList<String>(propertyNames);
                names.remove(this.helpArg.getFullName());
                names.remove(this.helpArg.getShortName());
            } else {
                names = propertyNames;
            }
            throw new CommandFormatException("Unrecognized argument names: " + names);
        }
    }
}

