/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public void parse(String str, ParsingStateCallbackHandler callbackHandler) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, initialState, true);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        try {
            StateParser.doParse(str, callbackHandler, initialState, strict);
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CommandFormatException("Failed to parse '" + str + "'", t);
        }
    }

    protected static void doParse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        if (str == null || str.isEmpty()) {
            return;
        }
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        ctx.input = str;
        ctx.strict = strict;
        ctx.ch = str.charAt(0);
        ctx.location = 0;
        initialState.getEnterHandler().handle(ctx);
        ctx.parse();
        ParsingState state = ctx.getState();
        while (state != ctx.initialState) {
            state.getEndContentHandler().handle(ctx);
            ctx.leaveState();
            state = ctx.getState();
        }
        initialState.getEndContentHandler().handle(ctx);
        initialState.getLeaveHandler().handle(ctx);
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        String input;
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;
        boolean strict;
        CommandFormatException error;
        CommandContext cmdCtx;
        private final Deque<Character> lookFor = new ArrayDeque<Character>();
        private char deactivated;

        ParsingContextImpl() {
        }

        void parse() throws CommandFormatException {
            while (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
                CharacterHandler handler = this.getState().getHandler(this.ch);
                handler.handle(this);
                ++this.location;
            }
        }

        @Override
        public boolean begins(String seq) {
            if (this.location + seq.length() < this.input.length()) {
                int i = 0;
                while (i < seq.length()) {
                    if (this.input.charAt(this.location + i) == seq.charAt(i++)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void replaceProperty(boolean exceptionIfNotResolved) throws CommandFormatException {
            if (this.input.charAt(this.location) == '$' && this.input.length() > this.location + 3 && this.input.charAt(this.location + 1) == '{') {
                int end = this.input.indexOf(125, this.location + 2);
                if (end == -1) {
                    return;
                }
                String prop = this.input.substring(this.location, end + 1);
                String resolved = Util.resolveProperties(prop);
                if (!resolved.equals(prop)) {
                    StringBuilder buf = new StringBuilder(this.input.length() - prop.length() + resolved.length());
                    buf.append(this.input.substring(0, this.location)).append(resolved);
                    if (end < this.input.length() - 1) {
                        buf.append(this.input.substring(end + 1));
                    }
                    this.input = buf.toString();
                    --this.location;
                } else if (exceptionIfNotResolved) {
                    throw new CommandFormatException("Couldn't resolve property " + prop + " in '" + this.input + "'");
                }
            }
        }

        @Override
        public boolean isStrict() {
            return this.strict;
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws CommandFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws CommandFormatException {
            this.stack.peek().getLeaveHandler().handle(this);
            this.callbackHandler.leavingState(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            } else {
                this.initialState.getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public void reenterState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public boolean isEndOfContent() {
            return this.location >= this.input.length();
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public void advanceLocation(int offset) throws IndexOutOfBoundsException {
            if (this.isEndOfContent()) {
                throw new IndexOutOfBoundsException("Location=" + this.location + ", offset=" + offset + ", length=" + this.input.length());
            }
            this.location += offset;
            if (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public CommandFormatException getError() {
            return this.error;
        }

        @Override
        public void setError(CommandFormatException e) {
            if (this.error == null) {
                this.error = e;
            }
        }

        @Override
        public void lookFor(char ch) {
            this.lookFor.push(Character.valueOf(ch));
        }

        @Override
        public boolean meetIfLookedFor(char ch) {
            if (this.lookFor.isEmpty() || this.lookFor.peek().charValue() != ch) {
                return false;
            }
            this.lookFor.pop();
            return true;
        }

        @Override
        public boolean isLookingFor(char c) {
            return !this.lookFor.isEmpty() && this.lookFor.peek().charValue() == c;
        }

        @Override
        public void deactivateControl(char c) {
            if (this.deactivated != '\u0000') {
                throw new IllegalStateException("Current implementation supports only one deactivated character at a time.");
            }
            this.deactivated = c;
        }

        @Override
        public void activateControl(char c) {
            if (this.deactivated == c) {
                this.deactivated = '\u0000';
            }
        }

        @Override
        public boolean isDeactivated(char c) {
            return this.deactivated == c;
        }
    }
}

