/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.scriptsupport;

import java.io.IOException;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.dmr.ModelNode;

public class CLI {
    private CommandContext ctx;

    private CLI() {
    }

    public static CLI newInstance() {
        return new CLI();
    }

    private void checkAlreadyConnected() {
        if (this.ctx != null) {
            throw new IllegalStateException("Already connected to server.");
        }
    }

    private void checkNotConnected() {
        if (this.ctx == null) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.ctx.isTerminated()) {
            throw new IllegalStateException("Session is terminated.");
        }
    }

    public CommandContext getCommandContext() {
        return this.ctx;
    }

    public void connect() {
        this.checkAlreadyConnected();
        try {
            this.ctx = CommandContextFactory.getInstance().newCommandContext();
            this.ctx.connectController();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Unable to initialize command context.", e);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException("Unable to connect to controller.", e);
        }
    }

    public void connect(String username, char[] password) {
        this.checkAlreadyConnected();
        try {
            this.ctx = CommandContextFactory.getInstance().newCommandContext(username, password);
            this.ctx.connectController();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Unable to initialize command context.", e);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException("Unable to connect to controller.", e);
        }
    }

    public void connect(String controllerHost, int controllerPort, String username, char[] password) {
        this.checkAlreadyConnected();
        try {
            this.ctx = CommandContextFactory.getInstance().newCommandContext(controllerHost, controllerPort, username, password);
            this.ctx.connectController();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Unable to initialize command context.", e);
        }
        catch (CommandLineException e) {
            throw new IllegalStateException("Unable to connect to controller.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            this.checkNotConnected();
            this.ctx.terminateSession();
        }
        finally {
            this.ctx = null;
        }
    }

    public Result cmd(String cliCommand) {
        this.checkNotConnected();
        try {
            ModelNode request = this.ctx.buildRequest(cliCommand);
            ModelNode response = this.ctx.getModelControllerClient().execute(request);
            return new Result(cliCommand, request, response);
        }
        catch (CommandFormatException cfe) {
            try {
                this.ctx.handle(cliCommand);
                return new Result(cliCommand, this.ctx.getExitCode());
            }
            catch (CommandLineException cle) {
                throw new IllegalArgumentException("Error handling command: " + cliCommand, cle);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to send command " + cliCommand + " to server.", ioe);
        }
    }

    public class Result {
        private String cliCommand;
        private ModelNode request;
        private ModelNode response;
        private boolean isSuccess = false;
        private boolean isLocalCommand = false;

        Result(String cliCommand, ModelNode request, ModelNode response) {
            this.cliCommand = cliCommand;
            this.request = request;
            this.response = response;
            this.isSuccess = response.get("outcome").asString().equals("success");
        }

        Result(String cliCommand, int exitCode) {
            this.cliCommand = cliCommand;
            this.isSuccess = exitCode == 0;
            this.isLocalCommand = true;
        }

        public String getCliCommand() {
            return this.cliCommand;
        }

        public ModelNode getRequest() {
            return this.request;
        }

        public ModelNode getResponse() {
            return this.response;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public boolean isLocalCommand() {
            return this.isLocalCommand;
        }
    }
}

