/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.extensions;

import java.security.Principal;
import java.security.acl.Group;
import org.jboss.security.identity.IdentityFactory;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class CredentialIdentityFactory
extends IdentityFactory {
    public static final CredentialIdentity NULL_IDENTITY = CredentialIdentityFactory.createIdentity(null, null);
    private static CredentialIdentityFactory _instance = null;

    protected CredentialIdentityFactory() {
    }

    public static CredentialIdentityFactory getInstance() {
        if (_instance == null) {
            _instance = new CredentialIdentityFactory();
        }
        return _instance;
    }

    public static CredentialIdentity<Object> createIdentity(Principal principal, Object cred) {
        if (principal == null && cred == null) {
            return NULL_IDENTITY;
        }
        return CredentialIdentityFactory.createIdentity(principal, cred, null);
    }

    public static CredentialIdentity<Object> createIdentity(final Principal principal, final Object cred, final Role roles) {
        return new CredentialIdentity<Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getCredential() {
                return cred;
            }

            @Override
            public void setCredential(Object credential) {
            }

            @Override
            public Group asGroup() {
                return null;
            }

            @Override
            public Principal asPrincipal() {
                return principal;
            }

            @Override
            public String getName() {
                return principal.getName();
            }

            @Override
            public Role getRole() {
                return roles;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("CredentialIdentity[principal=").append(principal);
                builder.append(";roles=").append(roles).append("]");
                return builder.toString();
            }
        };
    }
}

