/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualJarFileInputStream;
import org.jboss.vfs.VirtualJarInputStream;
import org.jboss.vfs.protocol.FileURLStreamHandler;
import org.jboss.vfs.protocol.VirtualFileURLStreamHandler;
import org.jboss.vfs.spi.MountHandle;
import org.jboss.vfs.util.PaddedManifestStream;
import org.jboss.vfs.util.PathTokenizer;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public class VFSUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String VFS_PROTOCOL = "vfs";
    public static final String FORCE_CASE_SENSITIVE_KEY = "jboss.vfs.forceCaseSensitive";
    public static final URLStreamHandler VFS_URL_HANDLER = new VirtualFileURLStreamHandler();
    public static final URLStreamHandler FILE_URL_HANDLER = new FileURLStreamHandler();
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private static boolean forceCaseSensitive = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String forceString = System.getProperty(VFSUtils.FORCE_CASE_SENSITIVE_KEY, "false");
            return Boolean.valueOf(forceString);
        }
    });
    private static final InputStream EMPTY_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");

    private VFSUtils() {
    }

    public static String getPathsString(Collection<VirtualFile> paths) {
        if (paths == null) {
            throw VFSMessages.MESSAGES.nullArgument("paths");
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (VirtualFile path : paths) {
            if (path == null) {
                throw new IllegalArgumentException("Null path in " + paths);
            }
            if (!first) {
                buffer.append(':');
            } else {
                first = false;
            }
            buffer.append(path.getPathName());
        }
        if (first) {
            buffer.append("<empty>");
        }
        return buffer.toString();
    }

    public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths) throws IOException {
        if (file == null) {
            throw VFSMessages.MESSAGES.nullArgument("file");
        }
        if (paths == null) {
            throw VFSMessages.MESSAGES.nullArgument("paths");
        }
        boolean trace = VFSLogger.ROOT_LOGGER.isTraceEnabled();
        Manifest manifest = VFSUtils.getManifest(file);
        if (manifest == null) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        if (classPath == null) {
            if (trace) {
                VFSLogger.ROOT_LOGGER.tracef("Manifest has no Class-Path for %s", (Object)file.getPathName());
            }
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            VFSLogger.ROOT_LOGGER.debugf("%s has no parent.", (Object)file);
            return;
        }
        if (trace) {
            VFSLogger.ROOT_LOGGER.tracef("Parsing Class-Path: %s for %s parent=%s", (Object)classPath, (Object)file.getName(), (Object)parent.getName());
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                VirtualFile vf = parent.getChild(path);
                if (vf.exists()) {
                    if (!paths.contains(vf)) {
                        paths.add(vf);
                        Automounter.mount(file, vf, new MountOption[0]);
                        VFSUtils.addManifestLocations(vf, paths);
                        continue;
                    }
                    if (!trace) continue;
                    VFSLogger.ROOT_LOGGER.tracef("%s from manifest is already in the classpath %s", (Object)vf.getName(), (Object)paths);
                    continue;
                }
                if (!trace) continue;
                VFSLogger.ROOT_LOGGER.trace("Unable to find " + path + " from " + parent.getName());
            }
            catch (IOException e) {
                VFSLogger.ROOT_LOGGER.debugf("Manifest Class-Path entry %s ignored for %s reason= %s", (Object)path, (Object)file.getPathName(), (Object)e);
            }
        }
    }

    public static Manifest getManifest(VirtualFile archive) throws IOException {
        if (archive == null) {
            throw VFSMessages.MESSAGES.nullArgument("archive");
        }
        VirtualFile manifest = archive.getChild("META-INF/MANIFEST.MF");
        if (manifest == null || !manifest.exists()) {
            if (VFSLogger.ROOT_LOGGER.isTraceEnabled()) {
                VFSLogger.ROOT_LOGGER.tracef("Can't find manifest for %s", (Object)archive.getPathName());
            }
            return null;
        }
        return VFSUtils.readManifest(manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(VirtualFile manifest) throws IOException {
        if (manifest == null) {
            throw VFSMessages.MESSAGES.nullArgument("manifest file");
        }
        PaddedManifestStream stream = new PaddedManifestStream(manifest.openStream());
        try {
            Manifest manifest2 = new Manifest(stream);
            return manifest2;
        }
        finally {
            VFSUtils.safeClose((Closeable)stream);
        }
    }

    public static String fixName(String name) {
        if (name == null) {
            throw VFSMessages.MESSAGES.nullArgument("name");
        }
        int length = name.length();
        if (length <= 1) {
            return name;
        }
        if (name.charAt(length - 1) == '/') {
            return name.substring(0, length - 1);
        }
        return name;
    }

    public static String decode(String path) {
        return VFSUtils.decode(path, DEFAULT_ENCODING);
    }

    public static String decode(String path, String encoding) {
        try {
            return URLDecoder.decode(path, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw VFSMessages.MESSAGES.cannotDecode(path, encoding, e);
        }
    }

    public static String getName(URI uri) {
        int lastSlash;
        if (uri == null) {
            throw VFSMessages.MESSAGES.nullArgument("uri");
        }
        String name = uri.getPath();
        if (name != null && (lastSlash = name.lastIndexOf(47)) > 0) {
            name = name.substring(lastSlash + 1);
        }
        return name;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        if (url == null) {
            throw VFSMessages.MESSAGES.nullArgument("url");
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            String urispec = url.toExternalForm();
            urispec = urispec.replaceAll("%", "%25");
            urispec = urispec.replaceAll(" ", "%20");
            return new URI(urispec);
        }
    }

    public static URL sanitizeURL(URL url) throws URISyntaxException, MalformedURLException {
        return VFSUtils.toURI(url).toURL();
    }

    public static void copyChildrenRecursive(VirtualFile original, VirtualFile target) throws IOException {
        if (original == null) {
            throw VFSMessages.MESSAGES.nullArgument("Original VirtualFile");
        }
        if (target == null) {
            throw VFSMessages.MESSAGES.nullArgument("Target VirtualFile");
        }
        List<VirtualFile> children = original.getChildren();
        for (VirtualFile child : children) {
            VirtualFile targetChild = target.getChild(child.getName());
            File childFile = child.getPhysicalFile();
            if (childFile.isDirectory()) {
                if (!targetChild.getPhysicalFile().mkdir()) {
                    throw VFSMessages.MESSAGES.problemCreatingNewDirectory(targetChild);
                }
                VFSUtils.copyChildrenRecursive(child, targetChild);
                continue;
            }
            FileInputStream is = new FileInputStream(childFile);
            VFSUtils.writeFile(targetChild, is);
        }
    }

    public static void copyStreamAndClose(InputStream is, OutputStream os) throws IOException {
        VFSUtils.copyStreamAndClose(is, os, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamAndClose(InputStream is, OutputStream os, int bufferSize) throws IOException {
        try {
            VFSUtils.copyStream(is, os, bufferSize);
            is.close();
            os.close();
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
            VFSUtils.safeClose((Closeable)os);
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        VFSUtils.copyStream(is, os, 65536);
    }

    public static void copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int rc;
        if (is == null) {
            throw VFSMessages.MESSAGES.nullArgument("input stream");
        }
        if (os == null) {
            throw VFSMessages.MESSAGES.nullArgument("output stream");
        }
        byte[] buff = new byte[bufferSize];
        while ((rc = is.read(buff)) != -1) {
            os.write(buff, 0, rc);
        }
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(VirtualFile virtualFile, byte[] bytes) throws IOException {
        File file = virtualFile.getPhysicalFile();
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(bytes);
            fos.close();
        }
        finally {
            VFSUtils.safeClose((Closeable)fos);
        }
    }

    public static void writeFile(VirtualFile virtualFile, InputStream is) throws IOException {
        File file = virtualFile.getPhysicalFile();
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        VFSUtils.copyStreamAndClose(is, fos);
    }

    public static URL getVirtualURL(VirtualFile file) throws MalformedURLException {
        try {
            final URI uri = VFSUtils.getVirtualURI(file);
            final String scheme = uri.getScheme();
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    if (VFSUtils.VFS_PROTOCOL.equals(scheme)) {
                        return new URL(null, uri.toString(), VFS_URL_HANDLER);
                    }
                    if ("file".equals(scheme)) {
                        return new URL(null, uri.toString(), FILE_URL_HANDLER);
                    }
                    return uri.toURL();
                }
            });
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getException();
        }
    }

    public static URI getVirtualURI(VirtualFile file) throws URISyntaxException {
        return new URI(VFS_PROTOCOL, "", file.getPathName(true), null);
    }

    public static URL getPhysicalURL(VirtualFile file) throws IOException {
        return VFSUtils.getPhysicalURI(file).toURL();
    }

    public static URI getPhysicalURI(VirtualFile file) throws IOException {
        return file.getPhysicalFile().toURI();
    }

    public static URL getRootURL(VirtualFile file) throws MalformedURLException {
        URI uri;
        try {
            uri = VFSUtils.getRootURI(file);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        return uri.toURL();
    }

    public static URI getRootURI(VirtualFile file) throws URISyntaxException {
        return VFS.getMount(file).getFileSystem().getRootURI();
    }

    public static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                VFSLogger.ROOT_LOGGER.trace("Failed to close resource", e);
            }
        }
    }

    public static void safeClose(Closeable ... closeables) {
        VFSUtils.safeClose(Arrays.asList(closeables));
    }

    public static void safeClose(Iterable<? extends Closeable> ci) {
        if (ci != null) {
            for (Closeable closeable : ci) {
                VFSUtils.safeClose(closeable);
            }
        }
    }

    public static void safeClose(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Exception e) {
                VFSLogger.ROOT_LOGGER.trace("Failed to close resource", e);
            }
        }
    }

    public static boolean isForceCaseSensitive() {
        return forceCaseSensitive;
    }

    public static boolean exists(File file) {
        try {
            boolean fileExists = file.exists();
            if (!forceCaseSensitive || !fileExists) {
                return fileExists;
            }
            String absPath = VFSUtils.canonicalize(file.getAbsolutePath());
            String canPath = VFSUtils.canonicalize(file.getCanonicalPath());
            return fileExists && absPath.equals(canPath);
        }
        catch (IOException io) {
            return false;
        }
    }

    public static boolean recursiveDelete(File root) {
        boolean ok = true;
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            if (files != null) {
                for (File file : files) {
                    ok &= VFSUtils.recursiveDelete(file);
                }
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }

    public static boolean recursiveDelete(VirtualFile root) {
        boolean ok = true;
        if (root.isDirectory()) {
            List<VirtualFile> files = root.getChildren();
            for (VirtualFile file : files) {
                ok &= VFSUtils.recursiveDelete(file);
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(File original, File destDir) throws IOException {
        String name = original.getName();
        File destFile = new File(destDir, name);
        if (original.isDirectory()) {
            destFile.mkdir();
            for (File file : original.listFiles()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                FileInputStream is = new FileInputStream(original);
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(File original, VirtualFile destDir) throws IOException {
        String name = original.getName();
        File destFile = destDir.getChild(name).getPhysicalFile();
        if (original.isDirectory()) {
            destFile.mkdir();
            for (File file : original.listFiles()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                FileInputStream is = new FileInputStream(original);
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(VirtualFile original, File destDir) throws IOException {
        String name = original.getName();
        File destFile = new File(destDir, name);
        if (original.isDirectory()) {
            destFile.mkdir();
            for (VirtualFile file : original.getChildren()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                InputStream is = original.openStream();
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(VirtualFile original, VirtualFile destDir) throws IOException {
        String name = original.getName();
        File destFile = destDir.getChild(name).getPhysicalFile();
        if (original.isDirectory()) {
            destFile.mkdir();
            for (VirtualFile file : original.getChildren()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                InputStream is = original.openStream();
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    public static InputStream emptyStream() {
        return EMPTY_STREAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createJarFileInputStream(VirtualFile virtualFile) throws IOException {
        if (virtualFile.isDirectory()) {
            VirtualJarInputStream jarInputStream = new VirtualJarInputStream(virtualFile);
            return new VirtualJarFileInputStream(jarInputStream);
        }
        InputStream inputStream = null;
        try {
            byte[] expectedHeader = new byte[]{80, 75, 3, 4};
            inputStream = virtualFile.openStream();
            byte[] bytes = new byte[4];
            int read = inputStream.read(bytes, 0, 4);
            if (read < 4 || !Arrays.equals(expectedHeader, bytes)) {
                throw VFSMessages.MESSAGES.invalidJarSignature(Arrays.toString(bytes), Arrays.toString(expectedHeader));
            }
        }
        catch (Throwable throwable) {
            VFSUtils.safeClose(inputStream);
            throw throwable;
        }
        VFSUtils.safeClose((Closeable)inputStream);
        return virtualFile.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            HashSet<File> createdDirs = new HashSet<File>();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            block9: while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                List<String> tokens = PathTokenizer.getTokens(name);
                Iterator<String> it = tokens.iterator();
                File current = destDir;
                while (it.hasNext()) {
                    String token = it.next();
                    if (PathTokenizer.isCurrentToken(token) || PathTokenizer.isReverseToken(token)) continue block9;
                    current = new File(current, token);
                    if (!it.hasNext() && !zipEntry.isDirectory() || !createdDirs.add(current)) continue;
                    current.mkdir();
                }
                if (zipEntry.isDirectory()) continue;
                InputStream is = zip.getInputStream(zipEntry);
                try {
                    FileOutputStream os = new FileOutputStream(current);
                    try {
                        VFSUtils.copyStream(is, os);
                        is.close();
                        os.close();
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)os);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)is);
                }
                current.setLastModified(zipEntry.getTime());
            }
        }
        finally {
            VFSUtils.safeClose(zip);
        }
    }

    public static File getMountSource(Closeable handle) {
        if (handle instanceof MountHandle) {
            return ((MountHandle)MountHandle.class.cast(handle)).getMountSource();
        }
        return null;
    }

    public static Pattern getGlobPattern(String glob) {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        Matcher m = GLOB_PATTERN.matcher(glob);
        boolean lastWasSlash = false;
        while (m.find()) {
            lastWasSlash = false;
            String grp = m.group(1);
            if (grp != null) {
                if (grp.length() == 2) {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append("[^/]*");
                continue;
            }
            grp = m.group(2);
            if (grp != null) {
                patternBuilder.append("[^/]");
                continue;
            }
            grp = m.group(3);
            if (grp != null) {
                patternBuilder.append(grp.charAt(1));
                continue;
            }
            grp = m.group(4);
            if (grp != null) {
                patternBuilder.append("/+");
                lastWasSlash = true;
                continue;
            }
            patternBuilder.append(Pattern.quote(m.group()));
        }
        if (lastWasSlash) {
            patternBuilder.append(".*");
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }

    public static String canonicalize(String path) {
        int length = path.length();
        int state = 0;
        if (length == 0) {
            return path;
        }
        char[] targetBuf = new char[length];
        int e = length;
        int i = length;
        int a = length - 1;
        int skip = 0;
        block16: while (--i >= 0) {
            char c = path.charAt(i);
            block0 : switch (c) {
                case '/': {
                    switch (state) {
                        case 0: {
                            state = 3;
                            e = i;
                            continue block16;
                        }
                        case 1: {
                            state = 3;
                            e = i;
                            continue block16;
                        }
                        case 2: {
                            state = 3;
                            e = i;
                            ++skip;
                            continue block16;
                        }
                        case 3: {
                            e = i;
                            continue block16;
                        }
                    }
                    throw new IllegalStateException();
                }
                case '.': {
                    switch (state) {
                        case 0: {
                            state = 1;
                            continue block16;
                        }
                        case 1: {
                            state = 2;
                            continue block16;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            state = 1;
                            continue block16;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            int newE = e > 0 ? path.lastIndexOf(47, e - 1) : -1;
            int segmentLength = e - newE - 1;
            if (skip > 0) {
                --skip;
            } else {
                if (state == 3) {
                    targetBuf[a--] = 47;
                }
                path.getChars(newE + 1, e, targetBuf, (a -= segmentLength) + 1);
            }
            state = 0;
            i = newE + 1;
            e = newE;
        }
        if (state == 3) {
            targetBuf[a--] = 47;
        }
        return new String(targetBuf, a + 1, length - a - 1);
    }
}

