/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model.validator;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;

public class NotEmptyResourceValidationStepHandler
implements ModelValidationStepHandler {
    public static NotEmptyResourceValidationStepHandler INSTANCE = new NotEmptyResourceValidationStepHandler();

    private NotEmptyResourceValidationStepHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateChildren(context, operation);
        context.stepCompleted();
    }

    protected void validateChildren(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (resource.getChildTypes().isEmpty()) {
            throw PicketLinkMessages.MESSAGES.emptyResource(pathAddress.getLastElement().toString());
        }
    }
}

