/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.keystore;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyRemoveHandler;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.KeyService;
import org.wildfly.extension.picketlink.federation.service.KeyStoreProviderService;

public class KeyAddHandler
extends AbstractAddStepHandler {
    static final KeyAddHandler INSTANCE = new KeyAddHandler();

    static void launchServices(OperationContext context, PathAddress pathAddress, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 2).getLastElement().getValue();
        String keyName = pathAddress.getLastElement().getValue();
        String host = KeyResourceDefinition.HOST.resolveModelAttribute(context, model).asString();
        KeyService service = new KeyService(keyName, host);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(KeyService.createServiceName(federationAlias, keyName), (Service)service);
        serviceBuilder.addDependency(KeyStoreProviderService.createServiceName(federationAlias), KeyStoreProviderService.class, service.getKeyStoreProviderService());
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : KeyResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        KeyAddHandler.launchServices(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model, verificationHandler, newControllers);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        try {
            KeyRemoveHandler.INSTANCE.performRuntime(context, operation, model);
        }
        catch (OperationFailedException ignore) {
            // empty catch block
        }
    }
}

