/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.keystore;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyAddHandler;
import org.wildfly.extension.picketlink.federation.service.KeyService;

public class KeyRemoveHandler
extends AbstractRemoveStepHandler {
    static final KeyRemoveHandler INSTANCE = new KeyRemoveHandler();

    private KeyRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 2).getLastElement().getValue();
        String keyName = pathAddress.getLastElement().getValue();
        context.removeService(KeyService.createServiceName(federationAlias, keyName));
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        KeyAddHandler.launchServices(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model, null, null);
    }
}

