/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.keystore;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderAddHandler;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderRemoveHandler;
import org.wildfly.extension.picketlink.federation.service.KeyStoreProviderService;

public class KeyStoreProviderResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition FILE = new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_FILE.getName(), ModelType.STRING, false).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_RELATIVE_TO.getName(), ModelType.STRING, true).setRequires(new String[]{ModelElement.COMMON_FILE.getName()}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.KEY_STORE_PASSWORD.getName(), ModelType.STRING, false).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.CREDENTIAL})).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition SIGN_KEY_ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.KEY_STORE_SIGN_KEY_ALIAS.getName(), ModelType.STRING, false).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.CREDENTIAL})).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition SIGN_KEY_PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.KEY_STORE_SIGN_KEY_PASSWORD.getName(), ModelType.STRING, false).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.CREDENTIAL})).setAllowExpression(true).build();
    public static final KeyStoreProviderResourceDefinition INSTANCE = new KeyStoreProviderResourceDefinition();

    private KeyStoreProviderResourceDefinition() {
        super(ModelElement.KEY_STORE, ModelElement.KEY_STORE.getName(), (OperationStepHandler)KeyStoreProviderAddHandler.INSTANCE, (OperationStepHandler)KeyStoreProviderRemoveHandler.INSTANCE, FILE, RELATIVE_TO, PASSWORD, SIGN_KEY_ALIAS, SIGN_KEY_PASSWORD);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(KeyResourceDefinition.INSTANCE, resourceRegistration);
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        return new AbstractWriteAttributeHandler(attributes.toArray(new AttributeDefinition[attributes.size()])){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
                PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                this.updateConfiguration(context, pathAddress, false);
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
                PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                this.updateConfiguration(context, pathAddress, true);
            }

            private void updateConfiguration(OperationContext context, PathAddress pathAddress, boolean rollback) throws OperationFailedException {
                String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
                ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                ServiceController serviceController = serviceRegistry.getService(KeyStoreProviderService.createServiceName(federationAlias));
                if (serviceController != null) {
                    ModelNode keyStoreProviderNode;
                    KeyStoreProviderService service = (KeyStoreProviderService)serviceController.getValue();
                    if (!rollback) {
                        keyStoreProviderNode = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
                    } else {
                        Resource rc = context.getOriginalRootResource().navigate(pathAddress);
                        keyStoreProviderNode = rc.getModel();
                    }
                    ModelNode relativeToNode = RELATIVE_TO.resolveModelAttribute(context, keyStoreProviderNode);
                    String relativeTo = null;
                    if (relativeToNode.isDefined()) {
                        relativeTo = relativeToNode.asString();
                    }
                    String file = FILE.resolveModelAttribute(context, keyStoreProviderNode).asString();
                    service.setKeyProviderType(KeyStoreProviderAddHandler.toKeyProviderType(context, keyStoreProviderNode), file, relativeTo);
                }
            }
        };
    }
}

