/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2EncryptionHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.federation.config.IDPConfiguration;
import org.wildfly.extension.picketlink.federation.config.SPConfiguration;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;
import org.wildfly.extension.picketlink.federation.service.FederationService;

public class ServiceProviderService
extends EntityProviderService<ServiceProviderService, SPConfiguration> {
    private static final String SERVICE_NAME = "SPConfigurationService";

    public ServiceProviderService(SPConfiguration configuration) {
        super(configuration);
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    @Override
    public void doConfigureDeployment(DeploymentUnit deploymentUnit) {
        this.configureIdentityProvider();
    }

    @Override
    protected List<Class<? extends SAML2Handler>> getDefaultHandlers() {
        ArrayList<Class<? extends SAML2Handler>> defaultHandlers = new ArrayList<Class<? extends SAML2Handler>>();
        defaultHandlers.add(SAML2LogOutHandler.class);
        defaultHandlers.add(SAML2AuthenticationHandler.class);
        defaultHandlers.add(RolesGenerationHandler.class);
        defaultHandlers.add(SAML2EncryptionHandler.class);
        defaultHandlers.add(SAML2SignatureValidationHandler.class);
        return defaultHandlers;
    }

    private void configureIdentityProvider() {
        IDPConfiguration idpConfiguration = ((FederationService)this.getFederationService().getValue()).getIdpConfiguration();
        if (idpConfiguration == null) {
            throw PicketLinkMessages.MESSAGES.federationIdentityProviderNotConfigured(((FederationService)this.getFederationService().getValue()).getAlias());
        }
        ((SPConfiguration)this.getConfiguration()).setIdentityURL(idpConfiguration.getIdentityURL());
    }
}

