/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.jpa.transaction;

import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.idm.jpa.transaction.TransactionalEntityManagerSynchronization;

public class TransactionalEntityManagerHelper {
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final TransactionManager transactionManager;

    public TransactionalEntityManagerHelper(TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager) {
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.transactionManager = transactionManager;
    }

    public EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return (EntityManager)this.transactionSynchronizationRegistry.getResource((Object)puScopedName);
    }

    public void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager) {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            transaction.registerSynchronization((Synchronization)new TransactionalEntityManagerSynchronization(entityManager));
            this.transactionSynchronizationRegistry.putResource((Object)scopedPuName, (Object)entityManager);
        }
        catch (Exception e) {
            throw PicketLinkMessages.MESSAGES.idmJpaFailedCreateTransactionEntityManager(e);
        }
    }
}

