/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class PartitionManagerRemoveHandler
extends AbstractRemoveStepHandler {
    static final PartitionManagerRemoveHandler INSTANCE = new PartitionManagerRemoveHandler();

    private PartitionManagerRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode partitionManagerNode) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String federationName = address.getLastElement().getValue();
        this.removeIdentityStoreServices(context, partitionManagerNode, federationName);
        context.removeService(PartitionManagerService.createServiceName(federationName));
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    void removeIdentityStoreServices(OperationContext context, ModelNode model, String federationName) throws OperationFailedException {
        ModelNode identityConfigurationNode = model.get(ModelElement.IDENTITY_CONFIGURATION.getName());
        if (!identityConfigurationNode.isDefined()) {
            throw PicketLinkMessages.MESSAGES.idmNoIdentityConfigurationProvided();
        }
        for (Property identityConfiguration : identityConfigurationNode.asPropertyList()) {
            String configurationName = identityConfiguration.getName();
            ModelNode value = identityConfiguration.getValue();
            if (!value.isDefined()) continue;
            for (Property store : value.asPropertyList()) {
                context.removeService(PartitionManagerService.createIdentityStoreServiceName(federationName, configurationName, store.getName()));
            }
        }
    }
}

