/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.component.CLIOutput;

public class DoOperationActionListener
extends AbstractAction {
    private CliGuiContext cliGuiCtx;
    private CLIOutput output;
    private LinkedList<String> cmdHistory = new LinkedList();

    public DoOperationActionListener(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.output = cliGuiCtx.getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = this.cliGuiCtx.getCommandLine().getCmdText().getText();
        try {
            this.cmdHistory.push(command);
            CommandExecutor.Response response = this.cliGuiCtx.getExecutor().doCommandFullResponse(command);
            this.postOutput(response);
        }
        catch (Exception e) {
            this.output.postCommandWithResponse(command, e.getMessage());
        }
        finally {
            this.cliGuiCtx.getTabs().setSelectedIndex(1);
        }
    }

    public List getCmdHistory() {
        return Collections.unmodifiableList(this.cmdHistory);
    }

    private void postOutput(CommandExecutor.Response response) throws BadLocationException {
        boolean verbose = this.cliGuiCtx.getCommandLine().isVerbose();
        if (verbose) {
            this.postVerboseOutput(response);
        } else {
            this.output.postCommandWithResponse(response.getCommand(), response.getDmrResponse().toString());
        }
    }

    private void postVerboseOutput(CommandExecutor.Response response) throws BadLocationException {
        this.output.postAttributed(response.getDmrResponse().toString() + "\n\n", null);
        this.output.postAttributed(response.getDmrRequest().toString() + "\n\n", null);
        this.output.postBold(response.getCommand() + "\n");
    }
}

