/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.cli.impl.VaultConfig;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.picketbox.plugins.vault.PicketBoxSecurityVault;

class CLIVaultReader {
    private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private volatile SecurityVault vault;

    CLIVaultReader() {
    }

    void init(VaultConfig vaultConfig) throws SecurityVaultException {
        if (vaultConfig.getCode() == null) {
            this.vault = new PicketBoxSecurityVault();
        } else {
            try {
                this.vault = vaultConfig.getModule() == null ? SecurityActions.loadAndInstantiateFromClassClassLoader(PicketBoxSecurityVault.class, SecurityVault.class, vaultConfig.getCode()) : SecurityActions.loadAndInstantiateFromModule(vaultConfig.getModule(), SecurityVault.class, vaultConfig.getCode());
            }
            catch (Exception e) {
                throw new SecurityVaultException((Throwable)e);
            }
        }
        this.vault.init(vaultConfig.getOptions());
    }

    String retrieve(String password) throws SecurityVaultException {
        if (this.isVaultFormat(password)) {
            char[] retrieved = this.getValue(password);
            return retrieved != null ? new String(retrieved) : null;
        }
        return password;
    }

    boolean isVaultFormat(String str) {
        return str != null && VAULT_PATTERN.matcher(str).matches();
    }

    private char[] getValue(String vaultString) throws SecurityVaultException {
        if (this.vault == null) {
            throw new SecurityVaultException("Vault has not been initialized.");
        }
        String[] tokens = this.tokens(vaultString);
        byte[] sharedKey = null;
        if (tokens.length > 2) {
            sharedKey = tokens[3].getBytes(CHARSET);
        }
        return this.vault.retrieve(tokens[1], tokens[2], sharedKey);
    }

    private String[] tokens(String vaultString) {
        StringTokenizer tokenizer = new StringTokenizer(vaultString, "::");
        int length = tokenizer.countTokens();
        String[] tokens = new String[length];
        int index = 0;
        while (tokenizer != null && tokenizer.hasMoreTokens()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }
}

