/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static String getEnv(final String key) {
        return System.getSecurityManager() == null ? System.getenv(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }

    static String getSystemProperty(final String key) {
        return System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static String getSystemProperty(final String key, final String defVal) {
        return System.getSecurityManager() == null ? System.getProperty(key, defVal) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defVal);
            }
        });
    }
}

