/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchBuilder;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.Context;

public class XmlFileState
implements Artifact.State {
    protected final File file;
    protected PatchBuilder patchBuilder;
    protected Patch patch;

    protected XmlFileState(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        this.file = file;
    }

    @Override
    public void validate(Context ctx) {
        if (!this.file.exists()) {
            ctx.getErrorHandler().error("File doesn't exist: " + this.file.getAbsolutePath());
        } else {
            try {
                this.patchBuilder = (PatchBuilder)PatchXml.parse(this.file);
            }
            catch (Exception e) {
                ctx.getErrorHandler().error("Failed to parse file: " + this.file.getAbsolutePath(), e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public Patch getPatch() {
        if (this.patch == null) {
            this.patch = this.patchBuilder.build();
        }
        return this.patch;
    }
}

