/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.jboss.ws.common.configuration.ConfigDelegateHandlerComparator;

public class HandlerChainSortInterceptor
extends AbstractPhaseInterceptor<Message> {
    private Binding binding;
    private static final Comparator<Handler> comparator = new ConfigDelegateHandlerComparator();

    public HandlerChainSortInterceptor(Binding b) {
        super("pre-protocol");
        this.binding = b;
        List hc = this.binding.getHandlerChain();
        if (hc.size() > 1) {
            Collections.sort(hc, comparator);
            this.binding.setHandlerChain(hc);
        }
    }

    public void handleMessage(Message message) throws Fault {
        List hc;
        Exchange ex;
        if (this.binding != null && (ex = message.getExchange()).get(HandlerChainInvoker.class) == null && (hc = this.binding.getHandlerChain()).size() > 1) {
            Collections.sort(hc, comparator);
            ex.put(HandlerChainInvoker.class, (Object)new HandlerChainInvoker(hc, this.isOutbound(message, ex)));
        }
    }

    private boolean isOutbound(Message message, Exchange ex) {
        return message == ex.getOutMessage() || message == ex.getOutFaultMessage();
    }
}

