/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFServlet;

final class WebMetaDataModifier {
    WebMetaDataModifier() {
    }

    void modify(Deployment dep) {
        JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebMetaData.class);
        if (jbossWebMD != null) {
            this.configureEndpoints(dep, jbossWebMD);
            this.modifyContextRoot(dep, jbossWebMD);
        }
    }

    private void configureEndpoints(Deployment dep, JBossWebMetaData jbossWebMD) {
        String transportClassName = this.getTransportClassName(dep);
        WSLogger.ROOT_LOGGER.modifyingServlets();
        HashSet<String> epNames = new HashSet<String>();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            epNames.add(ep.getTargetBeanName());
        }
        for (JBossServletMetaData servletMD : jbossWebMD.getServlets()) {
            String endpointClassName = ASHelper.getEndpointClassName((ServletMetaData)servletMD);
            if (endpointClassName == null || endpointClassName.length() <= 0) continue;
            if (epNames.contains(endpointClassName)) {
                servletMD.setServletClass(WSFServlet.class.getName());
                WSLogger.ROOT_LOGGER.settingTransportClass(transportClassName, endpointClassName);
                List<ParamValueMetaData> initParams = WebMetaDataHelper.getServletInitParams((ServletMetaData)servletMD);
                WebMetaDataHelper.newParamValue("org.jboss.wsf.spi.deployment.stackServletDelegateClass", transportClassName, initParams);
                WebMetaDataHelper.newParamValue("org.jboss.wsf.spi.deployment.integrationClassLoader", dep.getType().toString(), initParams);
                WebMetaDataHelper.newParamValue("jboss.ws.endpoint", endpointClassName, initParams);
                continue;
            }
            if (!endpointClassName.startsWith("org.apache.cxf")) continue;
            WSLogger.ROOT_LOGGER.invalidWSServlet(endpointClassName);
        }
    }

    private void modifyContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        String contextRoot = dep.getService().getContextRoot();
        WSLogger.ROOT_LOGGER.settingContextRoot(contextRoot, dep.getSimpleName());
        jbossWebMD.setContextRoot(contextRoot);
    }

    private String getTransportClassName(Deployment dep) {
        String transportClassName = (String)dep.getProperty("stack.transport.class");
        if (transportClassName == null) {
            throw WSMessages.MESSAGES.missingDeploymentProperty("stack.transport.class");
        }
        return transportClassName;
    }
}

