/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;

public class MultiFileHierarchicalConfiguration
extends AbstractHierarchicalFileConfiguration
implements ConfigurationListener,
ConfigurationErrorListener {
    private static final String FILE_URL_PREFIX = "file:";
    private static ThreadLocal recursive = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Map configurationsMap = new HashMap();
    private String pattern;
    private boolean init;

    public MultiFileHierarchicalConfiguration() {
        this.init = true;
    }

    public MultiFileHierarchicalConfiguration(String pathPattern) {
        this.pattern = pathPattern;
        this.init = true;
    }

    public void setFilePattern(String pathPattern) {
        this.pattern = pathPattern;
    }

    @Override
    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new AbstractHierarchicalFileConfiguration.FileConfigurationDelegate(this);
    }

    @Override
    public void addProperty(String key, Object value) {
        this.getConfiguration().addProperty(key, value);
    }

    @Override
    public void clear() {
        this.getConfiguration().clear();
    }

    @Override
    public void clearProperty(String key) {
        this.getConfiguration().clearProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.getConfiguration().containsKey(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getConfiguration().getBigDecimal(key, defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getConfiguration().getBigDecimal(key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getConfiguration().getBigInteger(key, defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getConfiguration().getBigInteger(key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getConfiguration().getBoolean(key, defaultValue);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getConfiguration().getBoolean(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getConfiguration().getBoolean(key);
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.getConfiguration().getByte(key, defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.getConfiguration().getByte(key, defaultValue);
    }

    @Override
    public byte getByte(String key) {
        return this.getConfiguration().getByte(key);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getConfiguration().getDouble(key, defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.getConfiguration().getDouble(key, defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.getConfiguration().getDouble(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.getConfiguration().getFloat(key, defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.getConfiguration().getFloat(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.getConfiguration().getFloat(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.getConfiguration().getInt(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.getConfiguration().getInt(key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getConfiguration().getInteger(key, defaultValue);
    }

    @Override
    public Iterator getKeys() {
        return this.getConfiguration().getKeys();
    }

    @Override
    public Iterator getKeys(String prefix) {
        return this.getConfiguration().getKeys(prefix);
    }

    @Override
    public List getList(String key, List defaultValue) {
        return this.getConfiguration().getList(key, defaultValue);
    }

    @Override
    public List getList(String key) {
        return this.getConfiguration().getList(key);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getConfiguration().getLong(key, defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.getConfiguration().getLong(key, defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.getConfiguration().getLong(key);
    }

    @Override
    public Properties getProperties(String key) {
        return this.getConfiguration().getProperties(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.getConfiguration().getShort(key, defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.getConfiguration().getShort(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return this.getConfiguration().getShort(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getConfiguration().getString(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.getConfiguration().getString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.getConfiguration().getStringArray(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getConfiguration().isEmpty();
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.init) {
            this.getConfiguration().setProperty(key, value);
        }
    }

    @Override
    public Configuration subset(String prefix) {
        return this.getConfiguration().subset(prefix);
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getConfiguration().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.init) {
            this.getConfiguration().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getConfiguration().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode rootNode) {
        if (this.init) {
            this.getConfiguration().setRootNode(rootNode);
        } else {
            super.setRootNode(rootNode);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    @Override
    public void addNodes(String key, Collection nodes) {
        this.getConfiguration().addNodes(key, nodes);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        return this.getConfiguration().configurationAt(key, supportUpdates);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key) {
        return this.getConfiguration().configurationAt(key);
    }

    @Override
    public List configurationsAt(String key) {
        return this.getConfiguration().configurationsAt(key);
    }

    @Override
    public void clearTree(String key) {
        this.getConfiguration().clearTree(key);
    }

    @Override
    public int getMaxIndex(String key) {
        return this.getConfiguration().getMaxIndex(key);
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getConfiguration().interpolatedConfiguration();
    }

    @Override
    public void addConfigurationListener(ConfigurationListener l) {
        super.addConfigurationListener(l);
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener l) {
        return super.removeConfigurationListener(l);
    }

    @Override
    public Collection getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        super.clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener l) {
        super.addErrorListener(l);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return super.removeErrorListener(l);
    }

    @Override
    public void clearErrorListeners() {
        super.clearErrorListeners();
    }

    @Override
    public Collection getErrorListeners() {
        return super.getErrorListeners();
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().save(writer);
        }
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().load(reader);
        }
    }

    @Override
    public void load() throws ConfigurationException {
        this.getConfiguration().load();
    }

    @Override
    public void load(String fileName) throws ConfigurationException {
        this.getConfiguration().load(fileName);
    }

    @Override
    public void load(File file) throws ConfigurationException {
        this.getConfiguration().load(file);
    }

    @Override
    public void load(URL url) throws ConfigurationException {
        this.getConfiguration().load(url);
    }

    @Override
    public void load(InputStream in) throws ConfigurationException {
        this.getConfiguration().load(in);
    }

    @Override
    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.getConfiguration().load(in, encoding);
    }

    @Override
    public void save() throws ConfigurationException {
        this.getConfiguration().save();
    }

    @Override
    public void save(String fileName) throws ConfigurationException {
        this.getConfiguration().save(fileName);
    }

    @Override
    public void save(File file) throws ConfigurationException {
        this.getConfiguration().save(file);
    }

    @Override
    public void save(URL url) throws ConfigurationException {
        this.getConfiguration().save(url);
    }

    @Override
    public void save(OutputStream out) throws ConfigurationException {
        this.getConfiguration().save(out);
    }

    @Override
    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.getConfiguration().save(out, encoding);
    }

    @Override
    public void configurationChanged(ConfigurationEvent event) {
        if (event.getSource() instanceof XMLConfiguration) {
            for (ConfigurationListener listener : this.getConfigurationListeners()) {
                listener.configurationChanged(event);
            }
        }
    }

    @Override
    public void configurationError(ConfigurationErrorEvent event) {
        if (event.getSource() instanceof XMLConfiguration) {
            for (ConfigurationErrorListener listener : this.getErrorListeners()) {
                listener.configurationError(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String key) {
        if (((Boolean)recursive.get()).booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(key);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguration() {
        String path = this.getSubstitutor().replace(this.pattern);
        Map map = this.configurationsMap;
        synchronized (map) {
            this.configurationsMap.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractHierarchicalFileConfiguration getConfiguration() {
        XMLConfiguration configuration;
        if (this.pattern == null) {
            throw new ConfigurationRuntimeException("File pattern must be defined");
        }
        String path = this.getSubstitutor().replace(this.pattern);
        Map map = this.configurationsMap;
        synchronized (map) {
            if (this.configurationsMap.containsKey(path)) {
                return (AbstractHierarchicalFileConfiguration)this.configurationsMap.get(path);
            }
        }
        if (path.equals(this.pattern)) {
            configuration = new XMLConfiguration(){

                @Override
                public void load() throws ConfigurationException {
                }

                @Override
                public void save() throws ConfigurationException {
                }
            };
            Map map2 = this.configurationsMap;
            synchronized (map2) {
                this.configurationsMap.put(this.pattern, configuration);
            }
            return configuration;
        }
        configuration = new XMLConfiguration();
        try {
            URL url = this.getURL(path);
            configuration.setURL(url);
            configuration.load();
            configuration.setExpressionEngine(this.getExpressionEngine());
            configuration.setReloadingStrategy(this.getReloadingStrategy());
            configuration.addConfigurationListener(this);
            configuration.addErrorListener(this);
            Map map3 = this.configurationsMap;
            synchronized (map3) {
                if (!this.configurationsMap.containsKey(path)) {
                    this.configurationsMap.put(path, configuration);
                }
            }
        }
        catch (ConfigurationException ce) {
            throw new ConfigurationRuntimeException((Throwable)((Object)ce));
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationRuntimeException(fnfe);
        }
        return configuration;
    }

    private URL getURL(String resourceLocation) throws FileNotFoundException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("A path pattern must be configured");
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new URL(FILE_URL_PREFIX + resourceLocation);
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is not a URL or a well-formed file path");
            }
        }
    }
}

