/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public abstract class XMLScanner
implements XMLComponent {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    protected boolean fValidation = false;
    protected boolean fNamespaces;
    protected boolean fNotifyCharRefs = false;
    protected boolean fParserSettings = true;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner;
    protected int fEntityDepth;
    protected String fCharRefLiteral = null;
    protected boolean fScanningAttribute;
    protected boolean fReportEntity;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fEncodingSymbol = "encoding".intern();
    protected static final String fStandaloneSymbol = "standalone".intern();
    protected static final String fAmpSymbol = "amp".intern();
    protected static final String fLtSymbol = "lt".intern();
    protected static final String fGtSymbol = "gt".intern();
    protected static final String fQuotSymbol = "quot".intern();
    protected static final String fAposSymbol = "apos".intern();
    private final XMLString fString = new XMLString();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();
    protected final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();

    @Override
    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        try {
            this.fParserSettings = componentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException e) {
            this.fParserSettings = true;
        }
        if (!this.fParserSettings) {
            this.init();
            return;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException e) {
            this.fValidation = false;
        }
        try {
            this.fNamespaces = componentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException e) {
            this.fNamespaces = true;
        }
        try {
            this.fNotifyCharRefs = componentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException e) {
            this.fNotifyCharRefs = false;
        }
        this.init();
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/symbol-table".length() && propertyId.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (suffixLength == "internal/error-reporter".length() && propertyId.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
            } else if (suffixLength == "internal/entity-manager".length() && propertyId.endsWith("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)value;
            }
        }
    }

    @Override
    public void setFeature(String featureId, boolean value) throws XMLConfigurationException {
        if (VALIDATION.equals(featureId)) {
            this.fValidation = value;
        } else if (NOTIFY_CHAR_REFS.equals(featureId)) {
            this.fNotifyCharRefs = value;
        }
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        if (VALIDATION.equals(featureId)) {
            return this.fValidation;
        }
        if (NOTIFY_CHAR_REFS.equals(featureId)) {
            return this.fNotifyCharRefs;
        }
        throw new XMLConfigurationException(0, featureId);
    }

    protected void reset() {
        this.init();
        this.fValidation = true;
        this.fNotifyCharRefs = false;
    }

    protected void scanXMLDeclOrTextDecl(boolean scanningTextDecl, String[] pseudoAttributeValues) throws IOException, XNIException {
        String version = null;
        String encoding = null;
        String standalone = null;
        boolean STATE_VERSION = false;
        boolean STATE_ENCODING = true;
        int STATE_STANDALONE = 2;
        int STATE_DONE = 3;
        int state = 0;
        boolean dataFoundForTarget = false;
        boolean sawSpace = this.fEntityScanner.skipDeclSpaces();
        XMLEntityManager.ScannedEntity currEnt = this.fEntityManager.getCurrentEntity();
        boolean currLiteral = currEnt.literal;
        currEnt.literal = false;
        while (this.fEntityScanner.peekChar() != 63) {
            dataFoundForTarget = true;
            String name = this.scanPseudoAttribute(scanningTextDecl, this.fString);
            switch (state) {
                case 0: {
                    if (name == fVersionSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        version = this.fString.toString();
                        state = 1;
                        if (this.versionSupported(version)) break;
                        this.reportFatalError(this.getVersionNotSupportedKey(), new Object[]{version});
                        break;
                    }
                    if (name == fEncodingSymbol) {
                        if (!scanningTextDecl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (scanningTextDecl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (name == fEncodingSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError(scanningTextDecl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        encoding = this.fString.toString();
                        state = scanningTextDecl ? 3 : 2;
                        break;
                    }
                    if (!scanningTextDecl && name == fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", new Object[]{standalone});
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (name == fStandaloneSymbol) {
                        if (!sawSpace) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        standalone = this.fString.toString();
                        state = 3;
                        if (standalone.equals("yes") || standalone.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", new Object[]{standalone});
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            sawSpace = this.fEntityScanner.skipDeclSpaces();
        }
        if (currLiteral) {
            currEnt.literal = true;
        }
        if (scanningTextDecl && state != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (scanningTextDecl) {
            if (!dataFoundForTarget && encoding == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!dataFoundForTarget && version == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        pseudoAttributeValues[0] = version;
        pseudoAttributeValues[1] = encoding;
        pseudoAttributeValues[2] = standalone;
    }

    public String scanPseudoAttribute(boolean scanningTextDecl, XMLString value) throws IOException, XNIException {
        String name = this.scanPseudoAttributeName();
        XMLEntityManager.print(this.fEntityManager.getCurrentEntity());
        if (name == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipDeclSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError(scanningTextDecl ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl", new Object[]{name});
        }
        this.fEntityScanner.skipDeclSpaces();
        int quote = this.fEntityScanner.peekChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError(scanningTextDecl ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl", new Object[]{name});
        }
        this.fEntityScanner.scanChar();
        int c = this.fEntityScanner.scanLiteral(quote, value);
        if (c != quote) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(value);
                if (c == -1) continue;
                if (c == 38 || c == 37 || c == 60 || c == 93) {
                    this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(c)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!this.isInvalidLiteral(c)) continue;
                String key = scanningTextDecl ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                this.reportFatalError(key, new Object[]{Integer.toString(c, 16)});
                this.fEntityScanner.scanChar();
            } while ((c = this.fEntityScanner.scanLiteral(quote, value)) != quote);
            this.fStringBuffer2.append(value);
            value.setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(quote)) {
            this.reportFatalError(scanningTextDecl ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl", new Object[]{name});
        }
        return name;
    }

    private String scanPseudoAttributeName() throws IOException, XNIException {
        int ch = this.fEntityScanner.peekChar();
        switch (ch) {
            case 118: {
                if (!this.fEntityScanner.skipString(fVersionSymbol)) break;
                return fVersionSymbol;
            }
            case 101: {
                if (!this.fEntityScanner.skipString(fEncodingSymbol)) break;
                return fEncodingSymbol;
            }
            case 115: {
                if (!this.fEntityScanner.skipString(fStandaloneSymbol)) break;
                return fStandaloneSymbol;
            }
        }
        return null;
    }

    protected void scanPI() throws IOException, XNIException {
        this.fReportEntity = false;
        String target = null;
        target = this.fNamespaces ? this.fEntityScanner.scanNCName() : this.fEntityScanner.scanName();
        if (target == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(target, this.fString);
        this.fReportEntity = true;
    }

    protected void scanPIData(String target, XMLString data) throws IOException, XNIException {
        if (target.length() == 3) {
            char c0 = Character.toLowerCase(target.charAt(0));
            char c1 = Character.toLowerCase(target.charAt(1));
            char c2 = Character.toLowerCase(target.charAt(2));
            if (c0 == 'x' && c1 == 'm' && c2 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                data.clear();
                return;
            }
            if (this.fNamespaces && this.fEntityScanner.peekChar() == 58) {
                this.fEntityScanner.scanChar();
                XMLStringBuffer colonName = new XMLStringBuffer(target);
                colonName.append(":");
                String str = this.fEntityScanner.scanName();
                if (str != null) {
                    colonName.append(str);
                }
                this.reportFatalError("ColonNotLegalWithNS", new Object[]{colonName.toString()});
                this.fEntityScanner.skipSpaces();
            } else {
                this.reportFatalError("SpaceRequiredInPI", null);
            }
        }
        this.fStringBuffer.clear();
        if (this.fEntityScanner.scanData("?>", this.fStringBuffer)) {
            do {
                int c;
                if ((c = this.fEntityScanner.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(c)) {
                    this.scanSurrogates(this.fStringBuffer);
                    continue;
                }
                if (!this.isInvalidLiteral(c)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(c)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", this.fStringBuffer));
        }
        data.setValues(this.fStringBuffer);
    }

    protected void scanComment(XMLStringBuffer text) throws IOException, XNIException {
        text.clear();
        while (this.fEntityScanner.scanData("--", text)) {
            int c = this.fEntityScanner.peekChar();
            if (c == -1) continue;
            if (XMLChar.isHighSurrogate(c)) {
                this.scanSurrogates(text);
                continue;
            }
            if (!this.isInvalidLiteral(c)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(c)});
            this.fEntityScanner.scanChar();
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("DashDashInComment", null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean scanAttributeValue(XMLString value, XMLString nonNormalizedValue, String atName, boolean checkEntities, String eleName) throws IOException, XNIException {
        int quote;
        block28: {
            quote = this.fEntityScanner.peekChar();
            if (quote != 39 && quote != 34) {
                this.reportFatalError("OpenQuoteExpected", new Object[]{eleName, atName});
            }
            this.fEntityScanner.scanChar();
            int entityDepth = this.fEntityDepth;
            int c = this.fEntityScanner.scanLiteral(quote, value);
            int fromIndex = 0;
            if (c == quote && (fromIndex = this.isUnchangedByNormalization(value)) == -1) {
                nonNormalizedValue.setValues(value);
                int cquote = this.fEntityScanner.scanChar();
                if (cquote != quote) {
                    this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
                }
                return true;
            }
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(value);
            this.normalizeWhitespace(value, fromIndex);
            if (c == quote) break block28;
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                block31: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block29: {
                                        String entityName;
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block30: {
                                                                int ch;
                                                                this.fStringBuffer.append(value);
                                                                if (c != 38) break block29;
                                                                this.fEntityScanner.skipChar(38);
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('&');
                                                                }
                                                                if (!this.fEntityScanner.skipChar(35)) break block30;
                                                                if (entityDepth == this.fEntityDepth) {
                                                                    this.fStringBuffer2.append('#');
                                                                }
                                                                if ((ch = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) == -1) {
                                                                    // empty if block
                                                                }
                                                                break block31;
                                                            }
                                                            entityName = this.fEntityScanner.scanName();
                                                            if (entityName == null) {
                                                                this.reportFatalError("NameRequiredInReference", null);
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(entityName);
                                                            }
                                                            if (!this.fEntityScanner.skipChar(59)) {
                                                                this.reportFatalError("SemicolonRequiredInReference", new Object[]{entityName});
                                                            } else if (entityDepth == this.fEntityDepth) {
                                                                this.fStringBuffer2.append(';');
                                                            }
                                                            if (entityName != fAmpSymbol) break block32;
                                                            this.fStringBuffer.append('&');
                                                            break block31;
                                                        }
                                                        if (entityName != fAposSymbol) break block33;
                                                        this.fStringBuffer.append('\'');
                                                        break block31;
                                                    }
                                                    if (entityName != fLtSymbol) break block34;
                                                    this.fStringBuffer.append('<');
                                                    break block31;
                                                }
                                                if (entityName != fGtSymbol) break block35;
                                                this.fStringBuffer.append('>');
                                                break block31;
                                            }
                                            if (entityName != fQuotSymbol) break block36;
                                            this.fStringBuffer.append('\"');
                                            break block31;
                                        }
                                        if (this.fEntityManager.isExternalEntity(entityName)) {
                                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{entityName});
                                            break block31;
                                        } else {
                                            if (!this.fEntityManager.isDeclaredEntity(entityName)) {
                                                if (checkEntities) {
                                                    if (this.fValidation) {
                                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{entityName}, (short)1);
                                                    }
                                                } else {
                                                    this.reportFatalError("EntityNotDeclared", new Object[]{entityName});
                                                }
                                            }
                                            this.fEntityManager.startEntity(entityName, true);
                                        }
                                        break block31;
                                    }
                                    if (c != 60) break block37;
                                    this.reportFatalError("LessthanInAttValue", new Object[]{eleName, atName});
                                    this.fEntityScanner.scanChar();
                                    if (entityDepth == this.fEntityDepth) {
                                        this.fStringBuffer2.append((char)c);
                                    }
                                    break block31;
                                }
                                if (c != 37 && c != 93) break block38;
                                this.fEntityScanner.scanChar();
                                this.fStringBuffer.append((char)c);
                                if (entityDepth == this.fEntityDepth) {
                                    this.fStringBuffer2.append((char)c);
                                }
                                break block31;
                            }
                            if (c != 10 && c != 13) break block39;
                            this.fEntityScanner.scanChar();
                            this.fStringBuffer.append(' ');
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append('\n');
                            }
                            break block31;
                        }
                        if (c == -1 || !XMLChar.isHighSurrogate(c)) break block40;
                        this.fStringBuffer3.clear();
                        if (this.scanSurrogates(this.fStringBuffer3)) {
                            this.fStringBuffer.append(this.fStringBuffer3);
                            if (entityDepth == this.fEntityDepth) {
                                this.fStringBuffer2.append(this.fStringBuffer3);
                            }
                        }
                        break block31;
                    }
                    if (c != -1 && this.isInvalidLiteral(c)) {
                        this.reportFatalError("InvalidCharInAttValue", new Object[]{eleName, atName, Integer.toString(c, 16)});
                        this.fEntityScanner.scanChar();
                        if (entityDepth == this.fEntityDepth) {
                            this.fStringBuffer2.append((char)c);
                        }
                    }
                }
                c = this.fEntityScanner.scanLiteral(quote, value);
                if (entityDepth == this.fEntityDepth) {
                    this.fStringBuffer2.append(value);
                }
                this.normalizeWhitespace(value);
            } while (c != quote || entityDepth != this.fEntityDepth);
            this.fStringBuffer.append(value);
            value.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        nonNormalizedValue.setValues(this.fStringBuffer2);
        int cquote = this.fEntityScanner.scanChar();
        if (cquote != quote) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{eleName, atName});
        }
        return nonNormalizedValue.equals(value.ch, value.offset, value.length);
    }

    protected void scanExternalID(String[] identifiers, boolean optionalSystemId) throws IOException, XNIException {
        String systemId = null;
        String publicId = null;
        if (this.fEntityScanner.skipString("PUBLIC")) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            publicId = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces() && !optionalSystemId) {
                this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
            }
        }
        if (publicId != null || this.fEntityScanner.skipString("SYSTEM")) {
            int quote;
            if (publicId == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((quote = this.fEntityScanner.peekChar()) != 39 && quote != 34) {
                if (publicId != null && optionalSystemId) {
                    identifiers[0] = null;
                    identifiers[1] = publicId;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            XMLString ident = this.fString;
            if (this.fEntityScanner.scanLiteral(quote, ident) != quote) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append(ident);
                    int c = this.fEntityScanner.peekChar();
                    if (XMLChar.isMarkup(c) || c == 93) {
                        this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                        continue;
                    }
                    if (XMLChar.isHighSurrogate(c)) {
                        this.scanSurrogates(this.fStringBuffer);
                        continue;
                    }
                    if (!this.isInvalidLiteral(c)) continue;
                    this.reportFatalError("InvalidCharInSystemID", new Object[]{Integer.toHexString(c)});
                    this.fEntityScanner.scanChar();
                } while (this.fEntityScanner.scanLiteral(quote, ident) != quote);
                this.fStringBuffer.append(ident);
                ident = this.fStringBuffer;
            }
            systemId = ident.toString();
            if (!this.fEntityScanner.skipChar(quote)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        identifiers[0] = systemId;
        identifiers[1] = publicId;
    }

    protected boolean scanPubidLiteral(XMLString literal) throws IOException, XNIException {
        int quote = this.fEntityScanner.scanChar();
        if (quote != 39 && quote != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean skipSpace = true;
        boolean dataok = true;
        while (true) {
            int c;
            if ((c = this.fEntityScanner.scanChar()) == 32 || c == 10 || c == 13) {
                if (skipSpace) continue;
                this.fStringBuffer.append(' ');
                skipSpace = true;
                continue;
            }
            if (c == quote) {
                if (skipSpace) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(c)) {
                this.fStringBuffer.append((char)c);
                skipSpace = false;
                continue;
            }
            if (c == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            dataok = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(c)});
        }
        literal.setValues(this.fStringBuffer);
        return dataok;
    }

    protected void normalizeWhitespace(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (c >= ' ') continue;
            value.ch[i] = 32;
        }
    }

    protected void normalizeWhitespace(XMLString value, int fromIndex) {
        int end = value.offset + value.length;
        for (int i = value.offset + fromIndex; i < end; ++i) {
            char c = value.ch[i];
            if (c >= ' ') continue;
            value.ch[i] = 32;
        }
    }

    protected int isUnchangedByNormalization(XMLString value) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            char c = value.ch[i];
            if (c >= ' ') continue;
            return i - value.offset;
        }
        return -1;
    }

    public void startEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        ++this.fEntityDepth;
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
    }

    public void endEntity(String name, Augmentations augs) throws XNIException {
        --this.fEntityDepth;
    }

    protected int scanCharReferenceValue(XMLStringBuffer buf, XMLStringBuffer buf2) throws IOException, XNIException {
        int c;
        boolean digit;
        boolean hex = false;
        if (this.fEntityScanner.skipChar(120)) {
            if (buf2 != null) {
                buf2.append('x');
            }
            hex = true;
            this.fStringBuffer3.clear();
            digit = true;
            c = this.fEntityScanner.peekChar();
            boolean bl = digit = c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
            if (digit) {
                if (buf2 != null) {
                    buf2.append((char)c);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)c);
                do {
                    boolean bl2 = digit = (c = this.fEntityScanner.peekChar()) >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
                    if (!digit) continue;
                    if (buf2 != null) {
                        buf2.append((char)c);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)c);
                } while (digit);
            } else {
                this.reportFatalError("HexdigitRequiredInCharRef", null);
            }
        } else {
            this.fStringBuffer3.clear();
            digit = true;
            c = this.fEntityScanner.peekChar();
            boolean bl = digit = c >= 48 && c <= 57;
            if (digit) {
                if (buf2 != null) {
                    buf2.append((char)c);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)c);
                do {
                    boolean bl3 = digit = (c = this.fEntityScanner.peekChar()) >= 48 && c <= 57;
                    if (!digit) continue;
                    if (buf2 != null) {
                        buf2.append((char)c);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)c);
                } while (digit);
            } else {
                this.reportFatalError("DigitRequiredInCharRef", null);
            }
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (buf2 != null) {
            buf2.append(';');
        }
        int value = -1;
        try {
            value = Integer.parseInt(this.fStringBuffer3.toString(), hex ? 16 : 10);
            if (this.isInvalid(value)) {
                StringBuffer errorBuf = new StringBuffer(this.fStringBuffer3.length + 1);
                if (hex) {
                    errorBuf.append('x');
                }
                errorBuf.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
                this.reportFatalError("InvalidCharRef", new Object[]{errorBuf.toString()});
            }
        }
        catch (NumberFormatException e) {
            StringBuffer errorBuf = new StringBuffer(this.fStringBuffer3.length + 1);
            if (hex) {
                errorBuf.append('x');
            }
            errorBuf.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
            this.reportFatalError("InvalidCharRef", new Object[]{errorBuf.toString()});
        }
        if (!XMLChar.isSupplemental(value)) {
            buf.append((char)value);
        } else {
            buf.append(XMLChar.highSurrogate(value));
            buf.append(XMLChar.lowSurrogate(value));
        }
        if (this.fNotifyCharRefs && value != -1) {
            String literal = "#" + (hex ? "x" : "") + this.fStringBuffer3.toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = literal;
            }
        }
        return value;
    }

    protected boolean isInvalid(int value) {
        return XMLChar.isInvalid(value);
    }

    protected boolean isInvalidLiteral(int value) {
        return XMLChar.isInvalid(value);
    }

    protected boolean isValidNameChar(int value) {
        return XMLChar.isName(value);
    }

    protected boolean isValidNameStartChar(int value) {
        return XMLChar.isNameStart(value);
    }

    protected boolean isValidNCName(int value) {
        return XMLChar.isNCName(value);
    }

    protected boolean isValidNameStartHighSurrogate(int value) {
        return false;
    }

    protected boolean versionSupported(String version) {
        return version.equals("1.0");
    }

    protected String getVersionNotSupportedKey() {
        return "VersionNotSupported";
    }

    protected boolean scanSurrogates(XMLStringBuffer buf) throws IOException, XNIException {
        int high = this.fEntityScanner.scanChar();
        int low = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(low)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(high, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        int c = XMLChar.supplemental((char)high, (char)low);
        if (this.isInvalid(c)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(c, 16)});
            return false;
        }
        buf.append((char)high);
        buf.append((char)low);
        return true;
    }

    protected void reportFatalError(String msgId, Object[] args) throws XNIException {
        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", msgId, args, (short)2);
    }

    private void init() {
        this.fEntityScanner = null;
        this.fEntityDepth = 0;
        this.fReportEntity = true;
        this.fResourceIdentifier.clear();
    }
}

