/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bg;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public final class BulgarianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    @Deprecated
    public static final String STOPWORDS_COMMENT = "#";
    private final Set<?> stemExclusionSet;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BulgarianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public BulgarianAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public BulgarianAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclusionSet));
    }

    public ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        Object result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new BulgarianStemFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = BulgarianAnalyzer.loadStopwordSet((boolean)false, (Class)BulgarianAnalyzer.class, (String)BulgarianAnalyzer.DEFAULT_STOPWORD_FILE, (String)BulgarianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

