/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.utils;

import java.util.Stack;
import org.jboss.logging.Logger;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.utils.ThreadLocalAssociation;

public class MessageContextAssociation {
    private static Logger log = Logger.getLogger(MessageContextAssociation.class);

    public static void pushMessageContext(CommonMessageContext msgContext) {
        Stack<CommonMessageContext> stack;
        if (log.isDebugEnabled()) {
            log.debug((Object)("pushMessageContext: " + msgContext + " (Thread " + Thread.currentThread().getName() + ")"));
        }
        if ((stack = ThreadLocalAssociation.localMsgContextAssoc().get()) == null) {
            stack = new Stack();
            ThreadLocalAssociation.localMsgContextAssoc().set(stack);
        }
        stack.push(msgContext);
    }

    public static CommonMessageContext peekMessageContext() {
        CommonMessageContext msgContext = null;
        Stack<CommonMessageContext> stack = ThreadLocalAssociation.localMsgContextAssoc().get();
        if (stack != null && !stack.isEmpty()) {
            msgContext = stack.peek();
        }
        return msgContext;
    }

    public static CommonMessageContext popMessageContext() {
        return MessageContextAssociation.popMessageContext(true);
    }

    public static CommonMessageContext popMessageContext(boolean clearDOMIfEmpty) {
        CommonMessageContext msgContext = null;
        Stack<CommonMessageContext> stack = ThreadLocalAssociation.localMsgContextAssoc().get();
        if (stack != null && !stack.isEmpty()) {
            msgContext = stack.pop();
            if (stack.isEmpty() && clearDOMIfEmpty) {
                DOMUtils.clearThreadLocals();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("popMessageContext: " + msgContext + " (Thread " + Thread.currentThread().getName() + ")"));
        }
        return msgContext;
    }
}

