/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLFeature;
import org.jboss.ws.metadata.wsdl.WSDLProperty;

public abstract class Extendable
implements Serializable {
    private static final long serialVersionUID = -3164210175211099488L;
    private Logger log = Logger.getLogger(this.getClass());
    private Map<String, WSDLFeature> features = new LinkedHashMap<String, WSDLFeature>();
    private Map<String, WSDLProperty> properties = new LinkedHashMap<String, WSDLProperty>();
    private Map<String, List<WSDLExtensibilityElement>> extElements = new LinkedHashMap<String, List<WSDLExtensibilityElement>>();
    private List<WSDLExtensibilityElement> notUnderstoodExtElements = new LinkedList<WSDLExtensibilityElement>();

    public WSDLFeature[] getFeatures() {
        WSDLFeature[] arr = new WSDLFeature[this.features.size()];
        new ArrayList<WSDLFeature>(this.features.values()).toArray(arr);
        return arr;
    }

    public void addFeature(WSDLFeature feature) {
        this.log.trace((Object)("addFeature: " + feature));
        String uri = feature.getURI();
        this.features.put(uri, feature);
    }

    public WSDLFeature getFeature(String uri) {
        WSDLFeature feature = this.features.get(uri);
        return feature;
    }

    public WSDLProperty[] getProperties() {
        WSDLProperty[] arr = new WSDLProperty[this.properties.size()];
        new ArrayList<WSDLProperty>(this.properties.values()).toArray(arr);
        return arr;
    }

    public void addProperty(WSDLProperty property) {
        this.log.trace((Object)("addProperty: " + property));
        String uri = property.getURI();
        this.properties.put(uri, property);
    }

    public WSDLProperty getProperty(String uri) {
        WSDLProperty property = this.properties.get(uri);
        return property;
    }

    public void addExtensibilityElement(WSDLExtensibilityElement extElement) {
        this.log.trace((Object)("addExtensibilityElement: " + extElement));
        String uri = extElement.getUri();
        List<WSDLExtensibilityElement> list = this.extElements.get(uri);
        if (list == null) {
            list = new LinkedList<WSDLExtensibilityElement>();
            this.extElements.put(uri, list);
        }
        list.add(extElement);
    }

    public List<WSDLExtensibilityElement> getExtensibilityElements(String uri) {
        ArrayList list = this.extElements.get(uri);
        return list == null ? new ArrayList() : list;
    }

    public List<WSDLExtensibilityElement> getAllExtensibilityElements() {
        LinkedList<WSDLExtensibilityElement> list = new LinkedList<WSDLExtensibilityElement>();
        for (String k : this.extElements.keySet()) {
            list.addAll((Collection<WSDLExtensibilityElement>)this.extElements.get(k));
        }
        return list;
    }

    public List<WSDLExtensibilityElement> getNotUnderstoodExtElements() {
        if (this.notUnderstoodExtElements == null) {
            this.notUnderstoodExtElements = new LinkedList<WSDLExtensibilityElement>();
        }
        return this.notUnderstoodExtElements;
    }

    public void setNotUnderstoodExtElements(List<WSDLExtensibilityElement> notUnderstoodExtElement) {
        this.notUnderstoodExtElements = notUnderstoodExtElement;
    }

    public void addNotUnderstoodExtElement(WSDLExtensibilityElement element) {
        if (this.notUnderstoodExtElements == null) {
            this.notUnderstoodExtElements = new LinkedList<WSDLExtensibilityElement>();
        }
        this.notUnderstoodExtElements.add(element);
    }
}

