/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;

public class TransactionScopedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 455498111L;
    private final String puScopedName;
    private final Map properties;
    private transient EntityManagerFactory emf;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf) {
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager result;
        boolean isInTx = TransactionUtil.isInTx();
        if (isInTx) {
            result = TransactionUtil.getOrCreateTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties);
        } else {
            result = NonTxEmCloser.get(this.puScopedName);
            if (result == null) {
                result = EntityManagerUtil.createEntityManager(this.emf, this.properties);
                NonTxEmCloser.add(this.puScopedName, result);
            }
        }
        return result;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return false;
    }

    @Override
    protected boolean isInTx() {
        return TransactionUtil.isInTx();
    }

    @Override
    public void close() {
        throw JpaMessages.MESSAGES.cannotCloseTransactionContainerEntityManger();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ServiceController controller = TransactionScopedEntityManager.currentServiceContainer().getService(JPAServiceNames.getPUServiceName((String)this.puScopedName));
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)controller.getService();
        this.emf = persistenceUnitService.getEntityManagerFactory();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

