/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    TRANSACTIONS_1_0("urn:jboss:domain:transactions:1.0"),
    TRANSACTIONS_1_1("urn:jboss:domain:transactions:1.1"),
    TRANSACTIONS_1_2("urn:jboss:domain:transactions:1.2"),
    TRANSACTIONS_1_3("urn:jboss:domain:transactions:1.3"),
    TRANSACTIONS_1_4("urn:jboss:domain:transactions:1.4"),
    TRANSACTIONS_1_5("urn:jboss:domain:transactions:1.5");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = TRANSACTIONS_1_5;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

