/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.dmr.ModelNode;

abstract class AccessAuthorizationRolesHandler
implements OperationStepHandler {
    final AuthorizerConfiguration authorizerConfiguration;

    static AccessAuthorizationRolesHandler getStandardRolesHandler(AuthorizerConfiguration authorizerConfiguration) {
        return new Standard(authorizerConfiguration);
    }

    static AccessAuthorizationRolesHandler getAllRolesHandler(AuthorizerConfiguration authorizerConfiguration) {
        return new All(authorizerConfiguration);
    }

    AccessAuthorizationRolesHandler(AuthorizerConfiguration configuration) {
        this.authorizerConfiguration = configuration;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Set<String> list = this.getRolesList();
        ModelNode result = context.getResult().setEmptyList();
        for (String role : list) {
            result.add(role);
        }
        context.stepCompleted();
    }

    abstract Set<String> getRolesList();

    private static class All
    extends AccessAuthorizationRolesHandler {
        private All(AuthorizerConfiguration configuration) {
            super(configuration);
        }

        @Override
        Set<String> getRolesList() {
            return this.authorizerConfiguration.getAllRoles();
        }
    }

    private static class Standard
    extends AccessAuthorizationRolesHandler {
        private Standard(AuthorizerConfiguration configuration) {
            super(configuration);
        }

        @Override
        Set<String> getRolesList() {
            return this.authorizerConfiguration.getStandardRoles();
        }
    }
}

