/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import org.jboss.as.domain.management.security.PropertiesFileLoader;

public class UserPropertiesFileLoader
extends PropertiesFileLoader {
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String REALM_COMMENT_SUFFIX = "$";
    private static final String REALM_COMMENT_COMMENT = " This line is used by the add-user utility to identify the realm name already used in this file.";
    private String realmName;
    private boolean realmWritten = false;

    public UserPropertiesFileLoader(String path) {
        super(path);
    }

    public String getRealmName() throws IOException {
        this.loadAsRequired();
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() throws IOException {
        super.load();
        String realmName = null;
        BufferedReader br = new BufferedReader(new FileReader(this.propertiesFile));
        try {
            String currentLine = null;
            while (realmName == null && (currentLine = br.readLine()) != null) {
                int start;
                int end;
                String trimmed = currentLine.trim();
                if (!trimmed.startsWith("#") || !trimmed.contains(REALM_COMMENT_PREFIX) || (end = trimmed.indexOf(REALM_COMMENT_SUFFIX, start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length())) <= -1) continue;
                realmName = trimmed.substring(start, end);
            }
        }
        finally {
            this.safeClose(br);
        }
        this.realmName = realmName;
    }

    @Override
    protected void beginPersistence() throws IOException {
        super.beginPersistence();
        this.realmWritten = false;
    }

    @Override
    protected void write(BufferedWriter writer, String line, boolean newLine) throws IOException {
        String trimmed;
        if (!this.realmWritten && (trimmed = line.trim()).startsWith("#") && trimmed.contains(REALM_COMMENT_PREFIX)) {
            this.realmWritten = true;
        }
        super.write(writer, line, newLine);
    }

    @Override
    protected void endPersistence(BufferedWriter writer) throws IOException {
        super.endPersistence(writer);
        if (!this.realmWritten) {
            this.writeRealm(writer, this.realmName);
        }
    }

    private void writeRealm(BufferedWriter bw, String realmName) throws IOException {
        bw.append("#");
        bw.newLine();
        bw.append("#");
        bw.append(REALM_COMMENT_PREFIX);
        bw.append(realmName);
        bw.append(REALM_COMMENT_SUFFIX);
        bw.append(REALM_COMMENT_COMMENT);
        bw.newLine();
        bw.append("#");
        bw.newLine();
    }
}

