/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.ValidateRealmState;

public class PromptRealmState
implements State {
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public PromptRealmState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
        this.theConsole.printf(DomainManagementMessages.MESSAGES.enterNewUserDetails(), new Object[0]);
        this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
        String existingRealm = this.stateValues.getRealm();
        if (existingRealm == null) {
            existingRealm = "";
        }
        switch (this.stateValues.getRealmMode()) {
            case DISCOVERED: {
                this.theConsole.printf(DomainManagementMessages.MESSAGES.discoveredRealm(existingRealm), new Object[0]);
                this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                return new PromptNewUserState(this.theConsole, this.stateValues);
            }
            case USER_SUPPLIED: {
                this.theConsole.printf(DomainManagementMessages.MESSAGES.userSuppliedRealm(existingRealm), new Object[0]);
                this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                return new PromptNewUserState(this.theConsole, this.stateValues);
            }
        }
        this.theConsole.printf(DomainManagementMessages.MESSAGES.realmPrompt(existingRealm), new Object[0]);
        String temp = this.theConsole.readLine(" : ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            return null;
        }
        if (temp.length() > 0 || this.stateValues.getRealm() == null) {
            this.stateValues.setRealm(temp);
        }
        return new ValidateRealmState(this.theConsole, this.stateValues);
    }
}

