/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public abstract class UpdatePropertiesHandler {
    private ConsoleWrapper theConsole;

    public UpdatePropertiesHandler(ConsoleWrapper theConsole) {
        this.theConsole = theConsole;
    }

    abstract void persist(String[] var1, File var2) throws IOException;

    abstract void persist(String[] var1, File var2, String var3) throws IOException;

    abstract String consoleUserMessage(String var1);

    abstract String consoleGroupsMessage(String var1);

    abstract String errorMessage(String var1, Throwable var2);

    State update(StateValues stateValues) {
        String[] entry = new String[2];
        try {
            String hash = new UsernamePasswordHashUtil().generateHashedHexURP(stateValues.getUserName(), stateValues.getRealm(), stateValues.getPassword().toCharArray());
            entry[0] = stateValues.getUserName();
            entry[1] = hash;
        }
        catch (NoSuchAlgorithmException e) {
            return new ErrorState(this.theConsole, e.getMessage(), null, stateValues);
        }
        for (File current : stateValues.getUserFiles()) {
            try {
                this.persist(entry, current, stateValues.getRealm());
                if (stateValues.isSilent()) continue;
                this.theConsole.printf(this.consoleUserMessage(current.getCanonicalPath()), new Object[0]);
                this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            }
            catch (Exception e) {
                return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
            }
        }
        if (stateValues.groupPropertiesFound() && stateValues.getGroups() != null) {
            for (File current : stateValues.getGroupFiles()) {
                String[] groups = new String[]{stateValues.getUserName(), stateValues.getGroups()};
                try {
                    this.persist(groups, current);
                    if (stateValues.isSilent()) continue;
                    this.theConsole.printf(this.consoleGroupsMessage(current.getCanonicalPath()), new Object[0]);
                    this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                }
                catch (IOException e) {
                    return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
                }
            }
        }
        return null;
    }
}

