/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.sun.net.httpserver.ExchangeImpl;
import org.jboss.sun.net.httpserver.LeftOverInputStream;
import org.jboss.sun.net.httpserver.WriteFinishedEvent;

class UndefLengthOutputStream
extends FilterOutputStream {
    private boolean closed = false;
    ExchangeImpl t;

    UndefLengthOutputStream(ExchangeImpl t, OutputStream src) {
        super(src);
        this.t = t;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        LeftOverInputStream is = this.t.getOriginalInputStream();
        if (!is.isClosed()) {
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        WriteFinishedEvent e = new WriteFinishedEvent(this.t);
        this.t.getHttpContext().getServerImpl().addEvent(e);
    }
}

