/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.jboss.as.domain.http.server.DomainApiHandler;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.http.server.security.DigestAuthenticator;
import org.jboss.as.domain.http.server.security.NonceFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.com.sun.net.httpserver.HttpsExchange;
import org.jboss.util.Base64;

class LogoutHandler
implements ManagementHttpHandler {
    private static final String BASIC = "BASIC";
    private static final String DIGEST = "DIGEST";
    private static final String MECHANISM = "mechanism";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private NonceFactory nonceFactory = new NonceFactory();
    private String realm;

    LogoutHandler() {
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext("/logout", (HttpHandler)this);
        this.realm = securityRealm != null ? securityRealm.getName() : null;
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext("/logout");
    }

    public void handle(HttpExchange exchange) throws IOException {
        Headers requestHeaders = exchange.getRequestHeaders();
        Headers responseHeaders = exchange.getResponseHeaders();
        if (this.realm == null) {
            responseHeaders.set("Location", DomainUtil.constructUrl(exchange, "/"));
            exchange.sendResponseHeaders(307, -1L);
        }
        String authorization = requestHeaders.getFirst("Authorization");
        String rawQuery = exchange.getRequestURI().getRawQuery();
        boolean query = rawQuery != null && rawQuery.contains("logout");
        String userAgent = requestHeaders.getFirst("User-Agent");
        boolean opera = userAgent != null && userAgent.contains("Opera");
        boolean win = !opera && userAgent != null && userAgent.contains("MSIE");
        String referrer = responseHeaders.getFirst("Referer");
        String protocol = exchange instanceof HttpsExchange ? "https" : "http";
        String host = null;
        if (referrer != null) {
            try {
                URI uri = new URI(referrer);
                protocol = uri.getScheme();
                host = uri.getHost() + this.portPortion(protocol, uri.getPort());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (host == null && (host = requestHeaders.getFirst("Host")) == null) {
            exchange.sendResponseHeaders(500, -1L);
            return;
        }
        if (!win) {
            boolean digest = true;
            Map<String, String> parameters = DomainApiHandler.decodeQuery(rawQuery);
            if (parameters.containsKey(MECHANISM)) {
                boolean bl = digest = !BASIC.equals(parameters.get(MECHANISM));
            }
            if (authorization != null && authorization.length() > BASIC.length() && BASIC.equalsIgnoreCase(authorization.substring(0, BASIC.length()))) {
                digest = false;
                authorization = new String(Base64.decode((String)authorization.substring(6)), UTF_8);
            }
            if (authorization == null || !authorization.contains("enter-login-here")) {
                String realm;
                if (!query) {
                    responseHeaders.set("Location", protocol + "://enter-login-here:blah@" + host + "/logout?logout&" + MECHANISM + "=" + (digest ? DIGEST : BASIC));
                    exchange.sendResponseHeaders(307, -1L);
                    return;
                }
                String string = realm = opera ? "HIT THE ESCAPE KEY" : this.realm;
                if (digest) {
                    DigestAuthenticator.DigestContext context = DigestAuthenticator.getOrCreateNegotiationContext(exchange, this.nonceFactory, false);
                    responseHeaders.add("WWW-Authenticate", "Digest " + DigestAuthenticator.createChallenge(context, realm, false));
                } else {
                    responseHeaders.add("WWW-Authenticate", "Basic realm=" + realm);
                }
                exchange.sendResponseHeaders(401, 0L);
                PrintStream print = new PrintStream(exchange.getResponseBody());
                print.println("<html><script type='text/javascript'>window.location=\"" + protocol + "://" + host + "/\";</script></html>");
                print.flush();
                print.close();
                return;
            }
        }
        responseHeaders.set("Location", protocol + "://" + host + "/");
        exchange.sendResponseHeaders(307, -1L);
    }

    private String portPortion(String scheme, int port) {
        if (port == -1 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            return "";
        }
        return ":" + String.valueOf(port);
    }
}

