/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.domain.http.server.security.SubjectHttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;

public class SubjectAssociationHandler
implements HttpHandler {
    private final HttpHandler wrapped;

    public SubjectAssociationHandler(HttpHandler wrapped) {
        this.wrapped = wrapped;
    }

    public void handle(HttpExchange exchange) throws IOException {
        HttpPrincipal principal = exchange.getPrincipal();
        Subject subject = principal instanceof SubjectHttpPrincipal ? ((SubjectHttpPrincipal)principal).getSubject() : new Subject();
        this.handleRequest(exchange, subject);
    }

    void handleRequest(final HttpExchange exchange, Subject subject) throws IOException {
        if (subject != null) {
            try {
                AccessAuditContext.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SubjectAssociationHandler.this.wrapped.handle(exchange);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            this.wrapped.handle(exchange);
        }
    }
}

