/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ejb.LockType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.PrimitiveClassLoaderUtil;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.ClusteringInfo;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class SessionBeanComponentCreateService
extends EJBComponentCreateService {
    private final Map<String, LockType> beanLevelLockType;
    private final Map<EJBBusinessMethod, LockType> methodApplicableLockTypes;
    private final Map<String, AccessTimeoutDetails> beanLevelAccessTimeout;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodApplicableAccessTimeouts;
    private final InjectedValue<ExecutorService> asyncExecutorService = new InjectedValue();
    private final ServiceName ejbObjectview;
    private final ServiceName ejbLocalObjectView;
    private final ClusteringInfo clustering;

    public SessionBeanComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        EJBViewDescription local;
        SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
        this.beanLevelLockType = sessionBeanComponentDescription.getBeanLevelLockType();
        Map<MethodIdentifier, LockType> methodLocks = sessionBeanComponentDescription.getMethodApplicableLockTypes();
        if (methodLocks == null) {
            this.methodApplicableLockTypes = Collections.emptyMap();
        } else {
            HashMap<EJBBusinessMethod, LockType> locks = new HashMap<EJBBusinessMethod, LockType>();
            for (Map.Entry<MethodIdentifier, LockType> entry : methodLocks.entrySet()) {
                MethodIdentifier ejbMethodDescription = entry.getKey();
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(ejbMethodDescription);
                locks.put(ejbMethod, entry.getValue());
            }
            this.methodApplicableLockTypes = Collections.unmodifiableMap(locks);
        }
        this.beanLevelAccessTimeout = sessionBeanComponentDescription.getBeanLevelAccessTimeout();
        Map<MethodIdentifier, AccessTimeoutDetails> methodAccessTimeouts = sessionBeanComponentDescription.getMethodApplicableAccessTimeouts();
        if (methodAccessTimeouts == null) {
            this.methodApplicableAccessTimeouts = Collections.emptyMap();
        } else {
            HashMap<EJBBusinessMethod, AccessTimeoutDetails> accessTimeouts = new HashMap<EJBBusinessMethod, AccessTimeoutDetails>();
            for (Map.Entry<MethodIdentifier, AccessTimeoutDetails> entry : methodAccessTimeouts.entrySet()) {
                MethodIdentifier ejbMethodDescription = entry.getKey();
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(ejbMethodDescription);
                accessTimeouts.put(ejbMethod, entry.getValue());
            }
            this.methodApplicableAccessTimeouts = Collections.unmodifiableMap(accessTimeouts);
        }
        if (sessionBeanComponentDescription.getScheduleMethods() != null) {
            for (Method method : sessionBeanComponentDescription.getScheduleMethods().keySet()) {
                this.processTxAttr(sessionBeanComponentDescription, MethodIntf.TIMER, method);
            }
        }
        if (sessionBeanComponentDescription.getTimeoutMethod() != null) {
            this.processTxAttr(sessionBeanComponentDescription, MethodIntf.TIMER, sessionBeanComponentDescription.getTimeoutMethod());
        }
        this.ejbLocalObjectView = (local = sessionBeanComponentDescription.getEjbLocalView()) == null ? null : local.getServiceName();
        EJBViewDescription remote = sessionBeanComponentDescription.getEjbRemoteView();
        this.ejbObjectview = remote == null ? null : remote.getServiceName();
        this.clustering = sessionBeanComponentDescription.getClustering();
    }

    public Map<String, LockType> getBeanLockType() {
        return this.beanLevelLockType;
    }

    public Map<EJBBusinessMethod, LockType> getMethodApplicableLockTypes() {
        return this.methodApplicableLockTypes;
    }

    public Map<EJBBusinessMethod, AccessTimeoutDetails> getMethodApplicableAccessTimeouts() {
        return this.methodApplicableAccessTimeouts;
    }

    public Map<String, AccessTimeoutDetails> getBeanAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    private EJBBusinessMethod getEJBBusinessMethod(MethodIdentifier method) {
        ClassLoader classLoader = this.getComponentClass().getClassLoader();
        String methodName = method.getName();
        String[] types = method.getParameterTypes();
        if (types == null || types.length == 0) {
            return new EJBBusinessMethod(methodName, new Class[0]);
        }
        Class[] paramTypes = new Class[types.length];
        int i = 0;
        for (String type : types) {
            try {
                paramTypes[i++] = PrimitiveClassLoaderUtil.loadClass(type, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return new EJBBusinessMethod(methodName, paramTypes);
    }

    public InjectedValue<ExecutorService> getAsyncExecutorService() {
        return this.asyncExecutorService;
    }

    public ServiceName getEjbLocalObjectView() {
        return this.ejbLocalObjectView;
    }

    public ServiceName getEjbObjectview() {
        return this.ejbObjectview;
    }

    public ClusteringInfo getClustering() {
        return this.clustering;
    }
}

