/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.interceptors.ComponentDispatcherInterceptor;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.interceptors.GetHomeInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.service.ServiceBuilder;

public abstract class SessionBeanObjectViewConfigurator
implements ViewConfigurator {
    private static final InterceptorFactory PRIMARY_KEY_INTERCEPTOR = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            throw EjbMessages.MESSAGES.cannotCallGetPKOnSessionBean();
        }
    });

    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        for (Method method : configuration.getProxyFactory().getCachedMethods()) {
            SessionBeanComponentDescription componentDescription;
            GetHomeInterceptorFactory factory;
            if (method.getName().equals("getPrimaryKey") && method.getParameterTypes().length == 0) {
                configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                configuration.addViewInterceptor(method, PRIMARY_KEY_INTERCEPTOR, 2560);
                continue;
            }
            if (method.getName().equals("remove") && method.getParameterTypes().length == 0) {
                this.handleRemoveMethod(componentConfiguration, configuration, index, method);
                continue;
            }
            if (method.getName().equals("getEJBLocalHome") && method.getParameterTypes().length == 0) {
                configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                factory = new GetHomeInterceptorFactory();
                configuration.addViewInterceptor(method, (InterceptorFactory)factory, 2560);
                componentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
                componentConfiguration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                        EjbHomeViewDescription ejbLocalHomeView = componentDescription.getEjbLocalHomeView();
                        if (ejbLocalHomeView == null) {
                            throw EjbMessages.MESSAGES.beanLocalHomeInterfaceIsNull(componentDescription.getComponentName());
                        }
                        serviceBuilder.addDependency(ejbLocalHomeView.getServiceName(), ComponentView.class, factory.getViewToCreate());
                    }
                });
                continue;
            }
            if (method.getName().equals("getEJBHome") && method.getParameterTypes().length == 0) {
                configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                factory = new GetHomeInterceptorFactory();
                configuration.addViewInterceptor(method, (InterceptorFactory)factory, 2560);
                componentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
                componentConfiguration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                        EjbHomeViewDescription ejbHomeView = componentDescription.getEjbHomeView();
                        if (ejbHomeView == null) {
                            throw EjbMessages.MESSAGES.beanHomeInterfaceIsNull(componentDescription.getComponentName());
                        }
                        serviceBuilder.addDependency(ejbHomeView.getServiceName(), ComponentView.class, factory.getViewToCreate());
                    }
                });
                continue;
            }
            if (method.getName().equals("getHandle") && method.getParameterTypes().length == 0) continue;
            if (method.getName().equals("isIdentical") && method.getParameterTypes().length == 1 && (method.getParameterTypes()[0].equals(EJBObject.class) || method.getParameterTypes()[0].equals(EJBLocalObject.class))) {
                this.handleIsIdenticalMethod(componentConfiguration, configuration, index, method);
                continue;
            }
            Method componentMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)index, (Class)componentConfiguration.getComponentClass(), (MethodIdentifier)MethodIdentifier.getIdentifierForMethod((Method)method));
            if (componentMethod != null) {
                if (!Modifier.isPublic(componentMethod.getModifiers())) {
                    throw EjbMessages.MESSAGES.ejbBusinessMethodMustBePublic(componentMethod);
                }
                configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ComponentDispatcherInterceptor(componentMethod)), 2560);
                configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                continue;
            }
            if (method.getDeclaringClass() == Object.class || method.getDeclaringClass() == WriteReplaceInterface.class) continue;
            throw EjbMessages.MESSAGES.couldNotFindViewMethodOnEjb(method, description.getViewClassName(), componentConfiguration.getComponentName());
        }
        configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
        configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
    }

    protected abstract void handleIsIdenticalMethod(ComponentConfiguration var1, ViewConfiguration var2, DeploymentReflectionIndex var3, Method var4);

    protected abstract void handleRemoveMethod(ComponentConfiguration var1, ViewConfiguration var2, DeploymentReflectionIndex var3, Method var4) throws DeploymentUnitProcessingException;

    protected Method resolveRemoveMethod(Class<?> componentClass, DeploymentReflectionIndex index, String ejbName) throws DeploymentUnitProcessingException {
        for (Class<?> clazz = componentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            ClassReflectionIndex classIndex = index.getClassIndex(clazz);
            Method ret = classIndex.getMethod(Void.TYPE, "ejbRemove", new Class[0]);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

