/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;
import org.jacorb.ssl.SSLPolicyValue;
import org.jacorb.ssl.SSLPolicyValueHelper;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.iiop.EjbCorbaServant;
import org.jboss.as.ejb3.iiop.POARegistry;
import org.jboss.as.ejb3.iiop.ReferenceFactory;
import org.jboss.as.ejb3.iiop.SecurityActions;
import org.jboss.as.ejb3.iiop.ServantRegistry;
import org.jboss.as.ejb3.iiop.stub.DynamicStubFactoryFactory;
import org.jboss.as.jacorb.rmi.ir.InterfaceRepository;
import org.jboss.as.jacorb.rmi.marshal.strategy.SkeletonStrategy;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.iiop.EJBMetaDataImplIIOP;
import org.jboss.ejb.iiop.HandleImplIIOP;
import org.jboss.ejb.iiop.HomeHandleImplIIOP;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.metadata.ejb.jboss.IIOPMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.POA;

public class EjbIIOPService
implements Service<EjbIIOPService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"EjbIIOPService"});
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final InjectedValue<ComponentView> homeView = new InjectedValue();
    private final InjectedValue<ComponentView> remoteView = new InjectedValue();
    private final InjectedValue<POARegistry> poaRegistry = new InjectedValue();
    private final InjectedValue<NamingContextExt> corbaNamingContext = new InjectedValue();
    private final InjectedValue<ORB> orb = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> serviceModuleLoaderInjectedValue = new InjectedValue();
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private EJBMetaData ejbMetaData;
    private final Map<String, SkeletonStrategy> beanMethodMap;
    private final Map<String, SkeletonStrategy> homeMethodMap;
    private final String[] beanRepositoryIds;
    private final String[] homeRepositoryIds;
    private final boolean useQualifiedName;
    private final Module module;
    private ServantRegistry homeServantRegistry;
    private ServantRegistry beanServantRegistry;
    private ReferenceFactory beanReferenceFactory;
    private EJBHome ejbHome;
    private InterfaceRepository iri;
    private final InjectedValue<POA> irPoa = new InjectedValue();
    private final InjectedValue<IORSecurityConfigMetaData> iorSecConfigMetaData = new InjectedValue();
    private IIOPMetaData iiopMetaData;
    private String name = null;

    public EjbIIOPService(Map<String, SkeletonStrategy> beanMethodMap, String[] beanRepositoryIds, Map<String, SkeletonStrategy> homeMethodMap, String[] homeRepositoryIds, boolean useQualifiedName, IIOPMetaData iiopMetaData, Module module) {
        this.useQualifiedName = useQualifiedName;
        this.module = module;
        this.beanMethodMap = Collections.unmodifiableMap(beanMethodMap);
        this.beanRepositoryIds = beanRepositoryIds;
        this.homeMethodMap = Collections.unmodifiableMap(homeMethodMap);
        this.homeRepositoryIds = homeRepositoryIds;
        this.iiopMetaData = iiopMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        try {
            RiverMarshallerFactory factory = new RiverMarshallerFactory();
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.serviceModuleLoaderInjectedValue.getValue())));
            this.configuration = configuration;
            this.factory = factory;
            boolean interfaceRepositorySupported = false;
            EJBComponent component = (EJBComponent)((java.lang.Object)this.ejbComponentInjectedValue.getValue());
            String earApplicationName = component.getEarApplicationName();
            if (this.iiopMetaData != null && this.iiopMetaData.getBindingName() != null) {
                this.name = this.iiopMetaData.getBindingName();
            } else if (this.useQualifiedName) {
                if (component.getDistinctName() == null || component.getDistinctName().isEmpty()) {
                    this.name = earApplicationName == null || earApplicationName.isEmpty() ? "" : earApplicationName + "/";
                    this.name = this.name + component.getModuleName() + "/" + component.getComponentName();
                } else {
                    this.name = earApplicationName == null || earApplicationName.isEmpty() ? "" : earApplicationName + "/";
                    this.name = this.name + component.getModuleName() + "/" + component.getDistinctName() + "/" + component.getComponentName();
                }
            } else {
                this.name = component.getComponentName();
            }
            this.name = this.name.replace(".", "_");
            ORB orb = (ORB)this.orb.getValue();
            IORSecurityConfigMetaData iorSecurityConfigMetaData = (IORSecurityConfigMetaData)this.iorSecConfigMetaData.getOptionalValue();
            if (this.iiopMetaData != null && this.iiopMetaData.getIorSecurityConfigMetaData() != null) {
                iorSecurityConfigMetaData = this.iiopMetaData.getIorSecurityConfigMetaData();
            }
            ArrayList<Policy> policyList = new ArrayList<Policy>();
            if (iorSecurityConfigMetaData != null) {
                Any secPolicy = orb.create_any();
                secPolicy.insert_Value((Serializable)iorSecurityConfigMetaData);
                Policy csiv2Policy = orb.create_policy(-2023406815, secPolicy);
                policyList.add(csiv2Policy);
                boolean sslRequired = false;
                if (iorSecurityConfigMetaData != null && iorSecurityConfigMetaData.getTransportConfig() != null) {
                    IORTransportConfigMetaData tc = iorSecurityConfigMetaData.getTransportConfig();
                    sslRequired = "REQUIRED".equals(tc.getIntegrity()) || "REQUIRED".equals(tc.getConfidentiality()) || "REQUIRED".equals(tc.getEstablishTrustInClient());
                }
                Any sslPolicyValue = orb.create_any();
                SSLPolicyValueHelper.insert((Any)sslPolicyValue, (SSLPolicyValue)(sslRequired ? SSLPolicyValue.SSL_REQUIRED : SSLPolicyValue.SSL_NOT_REQUIRED));
                Policy sslPolicy = orb.create_policy(101, sslPolicyValue);
                policyList.add(sslPolicy);
                EjbLogger.ROOT_LOGGER.debug("container's SSL policy: " + sslPolicy);
            }
            String securityDomain = "CORBA_REMOTE";
            if (component.getSecurityMetaData() != null) {
                securityDomain = component.getSecurityMetaData().getSecurityDomain();
            }
            Policy[] policies = policyList.toArray(new Policy[policyList.size()]);
            InterfaceDef homeInterfaceDef = null;
            if (this.iri != null) {
                Repository ir = this.iri.getReference();
                homeInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.homeRepositoryIds[0]));
            }
            Current poaCurrent = CurrentHelper.narrow((Object)orb.resolve_initial_references("POACurrent"));
            EjbCorbaServant homeServant = new EjbCorbaServant(poaCurrent, this.homeMethodMap, this.homeRepositoryIds, homeInterfaceDef, orb, (ComponentView)this.homeView.getValue(), (MarshallerFactory)factory, configuration, component.getTransactionManager(), (ClassLoader)this.module.getClassLoader(), true, securityDomain);
            this.homeServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithPersistentPOAPerServant();
            ReferenceFactory homeReferenceFactory = this.homeServantRegistry.bind(EjbIIOPService.homeServantName(this.name), homeServant, policies);
            Object corbaRef = homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
            this.ejbHome = (EJBHome)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBHome.class);
            HomeHandleImplIIOP homeHandle = new HomeHandleImplIIOP(orb.object_to_string(corbaRef));
            homeServant.setHomeHandle((HomeHandle)homeHandle);
            if (component instanceof EntityBeanComponent) {
                this.beanServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithPersistentPOAPerServant();
                EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
                Class<java.lang.Object> pkClass = entityBeanComponent.getPrimaryKeyClass();
                this.ejbMetaData = new EJBMetaDataImplIIOP(entityBeanComponent.getRemoteClass(), entityBeanComponent.getHomeClass(), pkClass, false, false, (HomeHandle)homeHandle);
            } else {
                this.beanServantRegistry = ((POARegistry)this.poaRegistry.getValue()).getRegistryWithTransientPOAPerServant();
                this.ejbMetaData = component instanceof StatelessSessionComponent ? new EJBMetaDataImplIIOP(((ComponentView)this.remoteView.getValue()).getViewClass(), ((ComponentView)this.homeView.getValue()).getViewClass(), null, true, true, (HomeHandle)homeHandle) : new EJBMetaDataImplIIOP(((ComponentView)this.remoteView.getValue()).getViewClass(), ((ComponentView)this.homeView.getValue()).getViewClass(), null, true, false, (HomeHandle)homeHandle);
            }
            homeServant.setEjbMetaData(this.ejbMetaData);
            InterfaceDef beanInterfaceDef = null;
            if (this.iri != null) {
                Repository ir = this.iri.getReference();
                beanInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.beanRepositoryIds[0]));
            }
            EjbCorbaServant beanServant = new EjbCorbaServant(poaCurrent, this.beanMethodMap, this.beanRepositoryIds, beanInterfaceDef, orb, (ComponentView)this.remoteView.getValue(), (MarshallerFactory)factory, configuration, component.getTransactionManager(), (ClassLoader)this.module.getClassLoader(), false, securityDomain);
            this.beanReferenceFactory = this.beanServantRegistry.bind(EjbIIOPService.beanServantName(this.name), beanServant, policies);
            EjbIIOPService.rebind((NamingContextExt)this.corbaNamingContext.getValue(), this.name, corbaRef);
            EjbLogger.ROOT_LOGGER.debug("Home IOR for " + component.getComponentName() + " bound to " + this.name + " in CORBA naming service");
            ClassLoader cl = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader((ClassLoader)this.module.getClassLoader());
                try {
                    DynamicStubFactoryFactory.makeStubClass(((ComponentView)this.homeView.getValue()).getViewClass());
                }
                catch (Exception e) {
                    EjbLogger.EJB3_LOGGER.dynamicStubCreationFailed(((ComponentView)this.homeView.getValue()).getViewClass().getName(), e);
                }
                try {
                    DynamicStubFactoryFactory.makeStubClass(((ComponentView)this.remoteView.getValue()).getViewClass());
                }
                catch (Exception e) {
                    EjbLogger.EJB3_LOGGER.dynamicStubCreationFailed(((ComponentView)this.remoteView.getValue()).getViewClass().getName(), e);
                }
            }
            finally {
                SecurityActions.setContextClassLoader(cl);
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        NamingContextExt corbaContext = (NamingContextExt)this.corbaNamingContext.getValue();
        try {
            NameComponent[] name = corbaContext.to_name(this.name);
            corbaContext.unbind(name);
        }
        catch (InvalidName invalidName) {
            EjbLogger.ROOT_LOGGER.cannotUnregisterEJBHomeFromCobra(invalidName);
        }
        catch (NotFound notFound) {
            EjbLogger.ROOT_LOGGER.cannotUnregisterEJBHomeFromCobra(notFound);
        }
        catch (CannotProceed cannotProceed) {
            EjbLogger.ROOT_LOGGER.cannotUnregisterEJBHomeFromCobra(cannotProceed);
        }
        try {
            this.homeServantRegistry.unbind(EjbIIOPService.homeServantName(this.name));
        }
        catch (Exception e) {
            EjbLogger.ROOT_LOGGER.cannotDeactivateHomeServant(e);
        }
        try {
            this.beanServantRegistry.unbind(EjbIIOPService.beanServantName(this.name));
        }
        catch (Exception e) {
            EjbLogger.ROOT_LOGGER.cannotDeactivateBeanServant(e);
        }
        if (this.iri != null) {
            this.iri.shutdown();
        }
        this.name = null;
    }

    public Object referenceForLocator(EJBLocator<?> locator) {
        EJBComponent ejbComponent = (EJBComponent)((java.lang.Object)this.ejbComponentInjectedValue.getValue());
        try {
            String earApplicationName;
            String string = earApplicationName = ejbComponent.getEarApplicationName() == null ? "" : ejbComponent.getEarApplicationName();
            if (locator.getBeanName().equals(ejbComponent.getComponentName()) && locator.getAppName().equals(earApplicationName) && locator.getModuleName().equals(ejbComponent.getModuleName()) && locator.getDistinctName().equals(ejbComponent.getDistinctName())) {
                if (locator instanceof EJBHomeLocator) {
                    return (Object)this.ejbHome;
                }
                if (locator instanceof StatelessEJBLocator) {
                    return this.beanReferenceFactory.createReference(this.beanRepositoryIds[0]);
                }
                if (locator instanceof StatefulEJBLocator) {
                    Marshaller marshaller = this.factory.createMarshaller(this.configuration);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)stream));
                    marshaller.writeObject((java.lang.Object)((StatefulEJBLocator)locator).getSessionId());
                    marshaller.finish();
                    return this.beanReferenceFactory.createReferenceWithId(stream.toByteArray(), this.beanRepositoryIds[0]);
                }
                if (locator instanceof EntityEJBLocator) {
                    Marshaller marshaller = this.factory.createMarshaller(this.configuration);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)stream));
                    marshaller.writeObject(((EntityEJBLocator)locator).getPrimaryKey());
                    marshaller.finish();
                    return this.beanReferenceFactory.createReferenceWithId(stream.toByteArray(), this.beanRepositoryIds[0]);
                }
                throw EjbMessages.MESSAGES.unknownEJBLocatorType(locator);
            }
            throw EjbMessages.MESSAGES.incorrectEJBLocatorForBean(locator, ejbComponent.getComponentName());
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.couldNotCreateCorbaObject(e, locator);
        }
    }

    public java.lang.Object handleForLocator(EJBLocator locator) {
        Object reference = this.referenceForLocator(locator);
        if (locator instanceof EJBHomeLocator) {
            return new HomeHandleImplIIOP(((ORB)this.orb.getValue()).object_to_string(reference));
        }
        return new HandleImplIIOP(((ORB)this.orb.getValue()).object_to_string(reference));
    }

    public static synchronized void rebind(NamingContextExt ctx, String strName, Object obj) throws Exception {
        NameComponent[] name = ctx.to_name(strName);
        NamingContextExt intermediateCtx = ctx;
        for (int i = 0; i < name.length - 1; ++i) {
            NameComponent[] relativeName = new NameComponent[]{name[i]};
            try {
                intermediateCtx = NamingContextHelper.narrow((Object)intermediateCtx.resolve(relativeName));
                continue;
            }
            catch (NotFound e) {
                intermediateCtx = intermediateCtx.bind_new_context(relativeName);
            }
        }
        intermediateCtx.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    private static String homeServantName(String jndiName) {
        return jndiName + "/home";
    }

    private static String beanServantName(String jndiName) {
        return jndiName + "/remote";
    }

    public EjbIIOPService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ComponentView> getRemoteView() {
        return this.remoteView;
    }

    public InjectedValue<ComponentView> getHomeView() {
        return this.homeView;
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }

    public InjectedValue<ORB> getOrb() {
        return this.orb;
    }

    public InjectedValue<NamingContextExt> getCorbaNamingContext() {
        return this.corbaNamingContext;
    }

    public InjectedValue<POARegistry> getPoaRegistry() {
        return this.poaRegistry;
    }

    public InjectedValue<POA> getIrPoa() {
        return this.irPoa;
    }

    public InjectedValue<ServiceModuleLoader> getServiceModuleLoaderInjectedValue() {
        return this.serviceModuleLoaderInjectedValue;
    }

    public InjectedValue<IORSecurityConfigMetaData> getIORSecConfigMetaDataInjectedValue() {
        return this.iorSecConfigMetaData;
    }
}

