/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SimplePrincipal;

public class AuthorizationInterceptor
implements Interceptor {
    private final EJBMethodSecurityAttribute ejbMethodSecurityMetaData;
    private final String viewClassName;
    private final Method viewMethod;
    private final String contextID;

    public AuthorizationInterceptor(EJBMethodSecurityAttribute ejbMethodSecurityMetaData, String viewClassName, Method viewMethod, String contextID) {
        if (ejbMethodSecurityMetaData == null) {
            throw EjbMessages.MESSAGES.ejbMethodSecurityMetaDataIsNull();
        }
        if (viewClassName == null || viewClassName.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.viewClassNameIsNull();
        }
        if (viewMethod == null) {
            throw EjbMessages.MESSAGES.viewMethodIsNull();
        }
        this.ejbMethodSecurityMetaData = ejbMethodSecurityMetaData;
        this.viewClassName = viewClassName;
        this.viewMethod = viewMethod;
        this.contextID = contextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, EJBComponent.class);
        }
        Method invokedMethod = context.getMethod();
        ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
        String viewClassOfInvokedMethod = componentView.getViewClass().getName();
        if (!this.viewClassName.equals(viewClassOfInvokedMethod) || !this.viewMethod.equals(invokedMethod)) {
            throw EjbMessages.MESSAGES.failProcessInvocation(this.getClass().getName(), invokedMethod, viewClassOfInvokedMethod, this.viewMethod, this.viewClassName);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        ServerSecurityManager securityManager = ejbComponent.getSecurityManager();
        MethodInterfaceType methodIntfType = this.getMethodInterfaceType((MethodIntf)((Object)componentView.getPrivateData(MethodIntf.class)));
        String previousContextID = this.setContextID(this.contextID);
        try {
            if (!securityManager.authorize(ejbComponent.getComponentName(), componentView.getProxyClass().getProtectionDomain().getCodeSource(), methodIntfType.name(), this.viewMethod, this.getMethodRolesAsPrincipals(), this.contextID)) {
                throw EjbMessages.MESSAGES.invocationOfMethodNotAllowed(invokedMethod, ejbComponent.getComponentName());
            }
            Object object = context.proceed();
            return object;
        }
        finally {
            this.setContextID(previousContextID);
        }
    }

    protected Set<Principal> getMethodRolesAsPrincipals() {
        HashSet<Principal> methodRoles = new HashSet<Principal>();
        if (this.ejbMethodSecurityMetaData.isDenyAll()) {
            methodRoles.add((Principal)NobodyPrincipal.NOBODY_PRINCIPAL);
        } else if (this.ejbMethodSecurityMetaData.isPermitAll()) {
            methodRoles.add((Principal)AnybodyPrincipal.ANYBODY_PRINCIPAL);
        } else {
            for (String role : this.ejbMethodSecurityMetaData.getRolesAllowed()) {
                methodRoles.add((Principal)new SimplePrincipal(role));
            }
        }
        return methodRoles;
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }

    protected String setContextID(String contextID) {
        if (System.getSecurityManager() == null) {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)contextID);
            return previousID;
        }
        SetContextIDAction action = new SetContextIDAction(contextID);
        return AccessController.doPrivileged(action);
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

